/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd;

import com.atlassian.crowd.service.cluster.ClusterNodeDetails;
import com.atlassian.crowd.service.cluster.ClusterService;
import com.atlassian.troubleshooting.api.ClusterNode;
import com.atlassian.troubleshooting.crowd.ActiveObjectsServiceProvider;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrowdClusterService
implements com.atlassian.troubleshooting.api.ClusterService {
    private final ClusterService clusterService;
    private final ActiveObjectsServiceProvider activeObjectsServiceProvider;

    @Autowired
    public CrowdClusterService(ClusterService clusterService, ActiveObjectsServiceProvider activeObjectsServiceProvider) {
        this.clusterService = Objects.requireNonNull(clusterService);
        this.activeObjectsServiceProvider = Objects.requireNonNull(activeObjectsServiceProvider);
    }

    @Override
    public boolean isClustered() {
        return this.activeObjectsServiceProvider.getActiveObjectsService().isPresent() && !this.clusterService.getInformation().getNodes().isEmpty();
    }

    @Override
    public Optional<ClusterNode> getCurrentNode() {
        return this.clusterService.getInformation().getNodes().stream().filter(com.atlassian.crowd.service.cluster.ClusterNode::isLocal).map(this::createNode).findFirst();
    }

    @Override
    public Optional<String> getCurrentNodeId() {
        return Optional.ofNullable(this.clusterService.getNodeId());
    }

    @Override
    @Nonnull
    public Collection<ClusterNode> getNodes() {
        return this.clusterService.getInformation().getNodes().stream().map(this::createNode).collect(Collectors.toList());
    }

    private ClusterNode createNode(com.atlassian.crowd.service.cluster.ClusterNode node) {
        return new ClusterNode(node.getNodeId(), node.getDetails().map(ClusterNodeDetails::getIpAddress).orElse(null), node.getNodeName());
    }
}

