/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd;

import com.atlassian.crowd.service.cluster.ClusterMessageListener;
import com.atlassian.crowd.service.cluster.ClusterMessageService;
import com.atlassian.troubleshooting.api.ClusterMessagingProvider;
import com.atlassian.troubleshooting.api.ListenerRegistration;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class CrowdClusterMessagingProvider
implements ClusterMessagingProvider {
    private final ClusterMessageService clusterMessageService;

    @Autowired
    public CrowdClusterMessagingProvider(ClusterMessageService clusterMessageService) {
        this.clusterMessageService = Objects.requireNonNull(clusterMessageService);
    }

    @Override
    public void sendMessage(String channel, String message) {
        this.clusterMessageService.publish(channel, message);
    }

    @Override
    public ListenerRegistration registerListener(String subscriptionChannel, Consumer<String> listener) {
        ClusterMessageListener crowdListener = (messageChannel, message) -> listener.accept(message);
        this.clusterMessageService.registerListener(crowdListener, subscriptionChannel);
        return () -> this.clusterMessageService.unregisterListener(crowdListener);
    }
}

