/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd;

import com.atlassian.crowd.service.HomeDirectoryService;
import com.atlassian.crowd.service.license.LicenseService;
import com.atlassian.crowd.support.SupportInformationService;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.troubleshooting.api.healthcheck.FileSystemInfo;
import com.atlassian.troubleshooting.crowd.CrowdFileSanitizerPatternManager;
import com.atlassian.troubleshooting.stp.hercules.HerculesRegexResource;
import com.atlassian.troubleshooting.stp.hercules.ScanItem;
import com.atlassian.troubleshooting.stp.hercules.regex.cacheables.SavedExternalResourceService;
import com.atlassian.troubleshooting.stp.properties.PropertyStore;
import com.atlassian.troubleshooting.stp.properties.SupportDataAppenderManager;
import com.atlassian.troubleshooting.stp.properties.SupportDataXmlKeyResolver;
import com.atlassian.troubleshooting.stp.request.FileSanitizer;
import com.atlassian.troubleshooting.stp.salext.AbstractSupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.ApplicationType;
import com.atlassian.troubleshooting.stp.salext.bundle.SupportZipBundleAccessor;
import com.atlassian.troubleshooting.stp.salext.license.ApplicationLicenseInfo;
import com.atlassian.troubleshooting.stp.salext.license.ProductLicenseInfo;
import com.atlassian.troubleshooting.stp.salext.mail.MailUtility;
import com.atlassian.troubleshooting.stp.salext.output.XmlSupportDataFormatter;
import com.atlassian.troubleshooting.stp.spi.SupportDataDetail;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.RollingFileAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrowdApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final String ROTATING_LOG_DESCRIPTION = "stp.hercules.scanitem.crowd.rot";
    private static final Pattern CROWD_HISTORICAL_LOG_FILE_PATTERN = Pattern.compile("^.*atlassian-crowd\\.log\\.[1-5]$");
    private static final String ATLASSIAN_CROWD_LOG_FILE = "atlassian-crowd.log";
    private final TransactionTemplate transactionTemplate;
    private final LicenseHandler licenseHandler;
    private final HomeDirectoryService homeDirectoryService;
    private final LicenseService licenseService;
    private final FileSystemInfo fileSystemInfo;
    private final SupportInformationService supportInformationService;

    @Autowired
    public CrowdApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, TemplateRenderer renderer, PluginAccessor pluginAccessor, SupportInformationService supportInformationService, TransactionTemplate transactionTemplate, LicenseHandler licenseHandler, HomeDirectoryService homeDirectoryService, LicenseService licenseService, SupportDataAppenderManager supportDataAppenderManager, SupportDataXmlKeyResolver supportDataXmlKeyResolver, XmlSupportDataFormatter xmlSupportDataFormatter, MailUtility mailUtility, SavedExternalResourceService savedExternalResourceService, FileSystemInfo fileSystemInfo, CrowdFileSanitizerPatternManager crowdFileSanitizerPatternManager, SupportZipBundleAccessor supportZipBundleAccessor) {
        super(applicationProperties, i18nResolver, renderer, supportDataAppenderManager, supportDataXmlKeyResolver, xmlSupportDataFormatter, pluginAccessor, mailUtility, savedExternalResourceService, crowdFileSanitizerPatternManager, supportZipBundleAccessor);
        this.supportInformationService = supportInformationService;
        this.transactionTemplate = transactionTemplate;
        this.licenseHandler = licenseHandler;
        this.homeDirectoryService = homeDirectoryService;
        this.licenseService = licenseService;
        this.fileSystemInfo = fileSystemInfo;
    }

    @Override
    public SisyphusPatternSource getPatternSource() {
        return this.getSourceFromCacheable(HerculesRegexResource.CROWD_HERCULES_REGEX);
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        File logDirectory = this.getLogFilePath();
        return ImmutableList.builder().add((Object)ScanItem.createDefaultItem(logDirectory.getPath() + File.separator + ATLASSIAN_CROWD_LOG_FILE)).addAll((Iterable)this.fileSystemInfo.listFiles(logDirectory, (dir, name) -> CROWD_HISTORICAL_LOG_FILE_PATTERN.asPredicate().test(name)).stream().map(file -> new ScanItem(ROTATING_LOG_DESCRIPTION, file.getPath())).collect(Collectors.toList())).build();
    }

    private File getLogFilePath() {
        try {
            File file;
            RollingFileAppender appender = (RollingFileAppender)LogManager.getRootLogger().getAppender("crowdlog");
            if (appender != null && (file = new File(appender.getFile()).getParentFile()) != null) {
                return file;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new File(this.applicationProperties.getHomeDirectory().getPath(), "logs");
    }

    @Override
    @Nonnull
    public File getExportDirectory() {
        return new File(this.homeDirectoryService.getSharedHome(), "export");
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "crowd-autosupportrequests@atlassian.com";
    }

    @Override
    protected PropertyStore internalLoadProperties(SupportDataDetail detail) {
        PropertyStore store = super.internalLoadProperties(detail);
        store.setValue("stp.properties.application.base.url", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        this.transactionTemplate.execute(() -> {
            Map supportInformation = this.supportInformationService.getSupportInformationMap(null);
            for (String key : supportInformation.keySet()) {
                store.setValue("crowd." + key.replace("\\W", "_"), (String)supportInformation.get(key));
            }
            return null;
        });
        return store;
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return false;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/console/secure/admin/mailserver.action";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(this.getFileSanitizerPatternManager(), EXECUTABLE_EXTENSIONS, this.getTempDirectory());
    }

    @Override
    public String getApplicationSEN() {
        return this.licenseHandler.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        return this.licenseHandler.getServerId();
    }

    @Override
    public String getLocalApplicationHome() {
        return this.homeDirectoryService.getLocalHome();
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        return new ProductLicenseInfo((ProductLicense)this.licenseService.getLicense());
    }

    @Override
    public String getAdminLicenseUrl() {
        return "/console/secure/admin/licensing.action";
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.CROWD;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(Starting\\sCrowd\\sServer)");
    }
}

