/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd;

import java.util.Objects;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActiveObjectsServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveObjectsServiceProvider.class);
    private final BundleContext bundleContext;
    private ServiceTracker tracker;

    @Autowired
    public ActiveObjectsServiceProvider(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public synchronized Optional<Object> getActiveObjectsService() {
        if (this.tracker == null) {
            this.tracker = new ServiceTracker(this.bundleContext, "com.atlassian.activeobjects.external.ActiveObjects", null);
            this.tracker.open();
        }
        try {
            return Optional.ofNullable(this.tracker.getService());
        }
        catch (Exception e) {
            LOGGER.debug("ActiveObjects service is not available on this instance", (Throwable)e);
            return Optional.empty();
        }
    }
}

