/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.servlet;

import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.Writer;
import java.util.HashMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.BaselineComparator;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.dto.BaselineSummary;
import tr.com.obss.plugin.services.PermissionService;
import tr.com.obss.plugin.utils.UrlUtils;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

public class BaseLineMainServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseLineMainServlet.class);
    private static final String BASELINE_MAIN_TEMPLATE = "/templates/baselineMain.vm";
    private static final String NOT_AUTH_TEMPLATE = "/templates/baselineNotAuth.vm";
    private static final String LICENSE_ERROR_TEMPLATE = "/templates/baselineInvalidLicense.vm";
    private final TemplateRenderer templateRenderer;
    private final SpaceManager spaceManager;
    private final UserHasCondition userHasCondition;
    private final UserManager userManager;
    private final PluginLicenseManager licenseManager;
    private final BaselineService baselineService;
    private final PermissionService permissionService;
    private final AccessModeService accessModeService;

    public BaseLineMainServlet(TemplateRenderer templateRenderer, SpaceManager spaceManager, BaselineService baselineService, PermissionService permissionService, PluginSettingsFactory pluginSettingsFactory, UserAccessor userAccessor, UserManager userManager, PluginLicenseManager licenseManager, AccessModeService accessModeService) {
        this.templateRenderer = templateRenderer;
        this.spaceManager = spaceManager;
        this.baselineService = baselineService;
        this.permissionService = permissionService;
        this.userManager = userManager;
        this.userHasCondition = new UserHasCondition(userAccessor, pluginSettingsFactory);
        this.licenseManager = licenseManager;
        this.accessModeService = accessModeService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.setContentType("text/html;charset=utf-8");
            HashMap<String, Object> context = new HashMap<String, Object>();
            ConfluenceActionSupport action = new ConfluenceActionSupport();
            if (null == AuthenticatedUserThreadLocal.get()) {
                this.templateRenderer.render(NOT_AUTH_TEMPLATE, context, (Writer)resp.getWriter());
                return;
            }
            if (!Utils.isLicenseValid(this.licenseManager)) {
                this.templateRenderer.render(LICENSE_ERROR_TEMPLATE, context, (Writer)resp.getWriter());
                return;
            }
            String spaceKey = req.getParameter("spaceKey");
            Space space = this.spaceManager.getSpace(spaceKey);
            boolean userCanViewSpace = this.permissionService.userCanViewSpace(space);
            if (spaceKey == null || space == null || !userCanViewSpace) {
                this.templateRenderer.render(NOT_AUTH_TEMPLATE, context, (Writer)resp.getWriter());
                return;
            }
            Boolean userIsInEditGroups = this.userHasCondition.isInEditGroups(AuthenticatedUserThreadLocal.getUsername());
            Boolean userIsInViewGroups = this.userHasCondition.isInViewGroups(AuthenticatedUserThreadLocal.getUsername());
            Boolean userIsInDeleteGroups = this.userHasCondition.isInDeleteGroups(AuthenticatedUserThreadLocal.getUsername());
            if (!userIsInEditGroups.booleanValue() && !userIsInViewGroups.booleanValue()) {
                this.templateRenderer.render(NOT_AUTH_TEMPLATE, (Writer)resp.getWriter());
                return;
            }
            TreeSet<BaselineSummary> baselines = new TreeSet<BaselineSummary>(new BaselineComparator());
            baselines.addAll(this.baselineService.getBaselineSummaries(space));
            boolean compare = Boolean.parseBoolean(req.getParameter("compare"));
            if (compare) {
                String baseline2;
                String baseline1 = req.getParameter("baseline1");
                if (baseline1 != null) {
                    context.put("baseline1", baseline1);
                }
                if ((baseline2 = req.getParameter("baseline2")) != null) {
                    context.put("baseline2", baseline2);
                }
            }
            context.put("readOnly", AccessMode.READ_ONLY == this.accessModeService.getAccessMode());
            context.put("compare", compare);
            context.put("baselines", baselines);
            context.put("selectedBaselineName", req.getParameter("baseline"));
            context.put("spaceKey", spaceKey);
            context.put("baseUrl", UrlUtils.getBaseUrl(req));
            context.put("isSysAdmin", this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey()));
            context.put("helper", action);
            context.put("canCreate", userIsInEditGroups.toString());
            context.put("canDelete", userIsInDeleteGroups.toString());
            this.templateRenderer.render(BASELINE_MAIN_TEMPLATE, context, (Writer)resp.getWriter());
        }
        catch (Exception e) {
            LOG.error("Error while opening main baseline page.", (Throwable)e);
        }
    }
}

