/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.progress;

import tr.com.obss.plugin.progress.BaselineProgress;

public class SimpleBaselineProgress
implements BaselineProgress {
    private final int stepCount;
    private final long startTime;
    private int currentPercentage;
    private int currentStep;
    private boolean failed;

    public SimpleBaselineProgress(int stepCount) {
        if (stepCount <= 0) {
            throw new IllegalArgumentException("stepCount must be greater than zero!");
        }
        this.stepCount = stepCount;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public synchronized int getCurrentPercentage() {
        return this.currentPercentage;
    }

    @Override
    public synchronized void setCompleted() {
        this.currentPercentage = 100;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setFailed() {
        this.failed = true;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    public synchronized void tick() {
        if (this.currentPercentage == 100) {
            return;
        }
        ++this.currentStep;
        if (this.currentStep > this.stepCount) {
            this.currentStep = this.stepCount;
        }
        this.calculateCurrentPercentage();
    }

    private void calculateCurrentPercentage() {
        int calculatedPercentage = (int)(100.0 * (double)this.currentStep / (double)this.stepCount);
        if (calculatedPercentage >= 100) {
            calculatedPercentage = 99;
        }
        this.currentPercentage = calculatedPercentage;
    }
}

