/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.core.task.longrunning.AbstractLongRunningTask;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.File;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import tr.com.obss.plugin.VersionSpecificGateKeeper;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportSemaphore;
import tr.com.obss.plugin.extra.flyingpdf.PdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.analytic.SpaceExportMetrics;
import tr.com.obss.plugin.extra.flyingpdf.html.DecorationPolicy;

public class PdfExportLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private TransactionTemplate transactionTemplate;
    private ImportExportManager importExportManager;
    private SpaceManager spaceManager;
    private PdfExporterService flyingPdfExporterService;
    private VersionSpecificGateKeeper gateKeeper;
    private final List<String> contentToBeExported;
    private final long spaceId;
    private final User remoteUser;
    private final String contextPath;
    private final PdfExportSemaphore pdfExportSemaphore;
    private final DecorationPolicy decorations;
    private PermissionManager permissionManager;
    private String downloadPath;

    public PdfExportLongRunningTask(List<String> contentToBeExported, Space space, User remoteUser, String contextPath, PdfExportSemaphore pdfExportSemaphore, DecorationPolicy decorations, PermissionManager permissionManager) {
        this.contentToBeExported = contentToBeExported;
        this.spaceId = space.getId();
        this.remoteUser = remoteUser;
        this.contextPath = contextPath;
        this.pdfExportSemaphore = pdfExportSemaphore;
        this.decorations = decorations;
        this.permissionManager = permissionManager;
    }

    protected void runInternal() {
        try {
            this.pdfExportSemaphore.run(this::doRunInternal);
        }
        catch (RuntimeException e) {
            this.progress.setCompletedSuccessfully(false);
            this.progress.setStatus(e.getMessage());
        }
    }

    private void doRunInternal() {
        try (Cleanup cleanup = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);){
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    AuthenticatedUserThreadLocal.setUser((User)PdfExportLongRunningTask.this.remoteUser);
                    RequestCacheThreadLocal.getRequestCache().put("confluence.context.path", PdfExportLongRunningTask.this.contextPath);
                    PdfExportProgressMonitor monitor = PdfExportLongRunningTask.this.flyingPdfExporterService.createProgressMonitor(PdfExportLongRunningTask.this.progress);
                    try {
                        monitor.beginCalculationOfContentTree();
                        Space space = PdfExportLongRunningTask.this.spaceManager.getSpace(PdfExportLongRunningTask.this.spaceId);
                        ContentTree contentTree = PdfExportLongRunningTask.this.importExportManager.getContentTree(PdfExportLongRunningTask.this.remoteUser, space);
                        if (PdfExportLongRunningTask.this.contentToBeExported != null && !PdfExportLongRunningTask.this.contentToBeExported.isEmpty()) {
                            contentTree.filter(PdfExportLongRunningTask.this.contentToBeExported);
                        }
                        monitor.completedCalculationOfContentTree(contentTree.size());
                        File pdfFile = PdfExportLongRunningTask.this.flyingPdfExporterService.createPdfForSpace(PdfExportLongRunningTask.this.remoteUser, space, contentTree, monitor, PdfExportLongRunningTask.this.contextPath, new SpaceExportMetrics(), PdfExportLongRunningTask.this.decorations);
                        PdfExportLongRunningTask.this.downloadPath = PdfExportLongRunningTask.this.importExportManager.prepareDownloadPath(pdfFile.getAbsolutePath());
                        Predicate<User> permissionPredicate = u -> PdfExportLongRunningTask.this.permissionManager.hasPermission(u, Permission.EXPORT, (Object)space);
                        PdfExportLongRunningTask.this.gateKeeper.addkey(PdfExportLongRunningTask.this.downloadPath, PdfExportLongRunningTask.this.remoteUser, permissionPredicate);
                        PdfExportLongRunningTask.this.downloadPath = PdfExportLongRunningTask.this.contextPath + PdfExportLongRunningTask.this.downloadPath;
                        monitor.completed(PdfExportLongRunningTask.this.downloadPath);
                    }
                    catch (Exception ex) {
                        AbstractLongRunningTask.log.error("Error during PDF export", (Throwable)ex);
                        String exceptionMessage = ex.getMessage();
                        if (StringUtils.isBlank((CharSequence)exceptionMessage)) {
                            exceptionMessage = ex.getClass().getName();
                        }
                        monitor.errored(exceptionMessage);
                    }
                    return null;
                }
            });
        }
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public String getName() {
        return "PDF Space Export";
    }

    public String getNameKey() {
        return "com.atlassian.confluence.extra.flyingpdf.exporttaskname";
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setFlyingPdfExporterService(PdfExporterService flyingPdfExporterService) {
        this.flyingPdfExporterService = flyingPdfExporterService;
    }

    public void setGateKeeper(VersionSpecificGateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

