/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.ConfluenceDirectories;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import tr.com.obss.plugin.extra.flyingpdf.OBSSExportFileNameGenerator;

public class OBSSConfluenceTempDirExportFileNameGenerator
implements OBSSExportFileNameGenerator {
    private static final AtomicLong uniqueId = new AtomicLong(1L);
    private final Supplier<File> tempDirectoryRef;
    private final String exportDirPrefix;
    private final String extension;
    private final String timeFormat;
    private final String combinedDateTimeFormat;

    public static OBSSExportFileNameGenerator create(ConfluenceDirectories confluenceDirectories, String exportDirPrefix, String extension, String dateFormat, String timeFormat) {
        return new OBSSConfluenceTempDirExportFileNameGenerator(() -> confluenceDirectories.getTempDirectory().toFile(), exportDirPrefix, extension, dateFormat, timeFormat);
    }

    public OBSSConfluenceTempDirExportFileNameGenerator(BootstrapManager bootstrapManager, String exportDirPrefix, String extension, String dateFormat, String timeFormat) {
        this(() -> ConfluenceDirectories.getLegacyTempDirectory((AtlassianBootstrapManager)((AtlassianBootstrapManager)Objects.requireNonNull(bootstrapManager))), exportDirPrefix, extension, dateFormat, timeFormat);
    }

    OBSSConfluenceTempDirExportFileNameGenerator(Supplier<File> tempDirectoryRef, String exportDirPrefix, String extension, String dateFormat, String timeFormat) {
        this.tempDirectoryRef = Objects.requireNonNull(tempDirectoryRef);
        this.exportDirPrefix = exportDirPrefix;
        this.extension = extension;
        this.timeFormat = timeFormat;
        this.combinedDateTimeFormat = dateFormat + "-" + timeFormat;
    }

    @Override
    public File createExportDirectory() throws IOException {
        File exportDir = this.getTempDirectoryFileInConfluenceTemp();
        if (exportDir.exists() && exportDir.isFile()) {
            throw new IOException("Export directory '" + exportDir.getAbsolutePath() + "' exists but is a file.");
        }
        if (!exportDir.exists() && !exportDir.mkdirs()) {
            throw new IOException("Couldn't create export directory " + exportDir.getAbsolutePath());
        }
        return exportDir;
    }

    private File getTempDirectoryFileInConfluenceTemp() {
        Date now = new Date();
        String fileNameDateParts = MessageFormat.format(this.combinedDateTimeFormat, now, now);
        String fileName = StringUtils.join(ImmutableList.of(this.exportDirPrefix, fileNameDateParts, Long.valueOf(uniqueId.getAndIncrement())), (char)'-');
        return new File(this.tempDirectoryRef.get(), fileName);
    }

    @Override
    public String getExportFileName(String ... differentiators) {
        StringBuilder builder = new StringBuilder();
        String[] var3 = differentiators;
        int var4 = differentiators.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String differentiator = var3[var5];
            builder.append(differentiator).append('-');
        }
        Date now = new Date();
        builder.append(MessageFormat.format(this.timeFormat, now, now));
        builder.append('-').append(uniqueId.getAndIncrement()).append('.').append(this.extension);
        return builder.toString();
    }
}

