/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.lowagie.text.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.IOUtils;
import org.xhtmlrenderer.pdf.ITextFSImage;
import tr.com.obss.plugin.extra.flyingpdf.LightITextFSImageUtilityMethods;
import tr.com.obss.plugin.extra.flyingpdf.util.ImageFileCacheUtils;
import tr.com.obss.plugin.extra.flyingpdf.util.ImageInformation;
import tr.com.obss.plugin.extra.flyingpdf.util.ImageInformationURICacheUtil;
import tr.com.obss.plugin.extra.flyingpdf.util.ImageTranscoderCacheUtil;

public class LightITextFSImage
extends ITextFSImage {
    private static final int DEFAULT_SVG_HEIGHT = 32;
    private static final int DEFAULT_SVG_WIDTH = 32;
    private static final String FILE_PREFIX = "file:";
    private final Supplier<InputStream> imgStreamSupplier;
    private IntWrapper width;
    private IntWrapper height;
    private final String uri;
    private final String baseUrl;

    public LightITextFSImage(Supplier<InputStream> imgStreamSupplier, float dotsPerPixel, String baseUrl, String uri) throws IOException {
        super(null);
        this.imgStreamSupplier = imgStreamSupplier;
        this.baseUrl = baseUrl;
        this.uri = uri;
        this.width = new IntWrapper();
        this.height = new IntWrapper();
        this.updateMeasurements(dotsPerPixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMeasurements(float dotsPerPixel) throws IOException {
        ImageInformation imageInfo = ImageInformationURICacheUtil.getCacheURI(this.uri);
        if (imageInfo != null && imageInfo.getTempFileName() == null) {
            throw new IOException("Unknown image format");
        }
        if (imageInfo != null) {
            this.width.setValue(imageInfo.getWidth());
            this.height.setValue(imageInfo.getHeight());
        } else {
            File tempFile = this.createTempFileFromInputStream();
            try (ImageInputStream in = ImageIO.createImageInputStream(new FileInputStream(tempFile));){
                ImageInformation cacheInformation;
                Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                if (readers.hasNext()) {
                    ImageReader reader = readers.next();
                    try {
                        reader.setInput(in);
                        this.width.setValue((int)(dotsPerPixel * (float)reader.getWidth(0)));
                        this.height.setValue((int)(dotsPerPixel * (float)reader.getHeight(0)));
                        cacheInformation = new ImageInformation(this.height.getValue(), this.width.getValue(), tempFile.getAbsolutePath(), false);
                    }
                    finally {
                        reader.dispose();
                    }
                } else {
                    cacheInformation = LightITextFSImageUtilityMethods.updateMeasurementsForSvg(dotsPerPixel, tempFile, this.uri, 32, 32, this.width, this.height);
                }
                ImageInformationURICacheUtil.setCacheURI(this.uri, cacheInformation);
            }
        }
    }

    private File createTempFileFromInputStream() throws IOException {
        InputStream imgStream = this.imgStreamSupplier.get();
        try {
            File file = ImageFileCacheUtils.createTempFile(imgStream);
            return file;
        }
        finally {
            IOUtils.closeQuietly((InputStream)imgStream);
        }
    }

    @Override
    public int getWidth() {
        return this.width.getValue();
    }

    @Override
    public int getHeight() {
        return this.height.getValue();
    }

    @Override
    public void scale(int width, int height) {
        int targetWidth = width;
        int targetHeight = height;
        if (targetWidth == -1) {
            targetWidth = (int)((double)this.getWidth() * ((double)targetHeight / (double)this.getHeight()));
        }
        if (targetHeight == -1) {
            targetHeight = (int)((double)this.getHeight() * ((double)targetWidth / (double)this.getWidth()));
        }
        this.width.setValue(targetWidth != 0 ? targetWidth : this.getWidth());
        this.height.setValue(targetHeight != 0 ? targetHeight : this.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage() {
        Image image;
        InputStream imageInputStream;
        String imageTempFile = ImageTranscoderCacheUtil.getCacheImage(this.uri);
        if (imageTempFile == null) {
            ImageInformation imageInformation = ImageInformationURICacheUtil.getCacheURI(this.uri);
            imageTempFile = imageInformation.isSVGImage() ? LightITextFSImageUtilityMethods.getTempFileNameForSvg(imageTempFile, imageInformation, this.uri, this.width, this.height) : imageInformation.getTempFileName();
        }
        if (imageTempFile != null) {
            imageInputStream = new FileInputStream(imageTempFile);
        } else if (!this.isExternalResource()) {
            imageInputStream = this.imgStreamSupplier.get();
        } else {
            throw new RuntimeException("Failed to read image");
        }
        try {
            BufferedImage jImage = ImageIO.read(imageInputStream);
            Image image2 = Image.getInstance(jImage, null);
            image2.scaleAbsolute(this.width.getValue(), this.height.getValue());
            image = image2;
        }
        catch (Exception e) {
            Image image3;
            try {
                image3 = LightITextFSImageUtilityMethods.getSvgImage(this.uri, this.width, this.height);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)imageInputStream);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new RuntimeException("Failed to read image", e2);
                }
            }
            IOUtils.closeQuietly((InputStream)imageInputStream);
            return image3;
        }
        IOUtils.closeQuietly((InputStream)imageInputStream);
        return image;
    }

    private boolean isExternalResource() {
        return this.uri != null && !this.uri.startsWith(FILE_PREFIX) && !this.uri.startsWith(this.baseUrl) && !this.uri.startsWith("/");
    }

    class IntWrapper {
        private int value;

        IntWrapper() {
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

