/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Objects;
import tr.com.obss.plugin.utils.Utils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SelectedPage {
    private String id;
    private String version = "latest";

    public SelectedPage() {
    }

    public SelectedPage(String id) {
        this.id = id;
    }

    public SelectedPage(String id, String version) {
        this.id = id;
        this.version = version;
    }

    public SelectedPage(String id, Integer version) {
        this.id = id;
        this.version = String.valueOf(version);
    }

    public static CollectionType getListCollectionType() {
        return TypeFactory.defaultInstance().constructCollectionType(SelectedPages.class, SelectedPage.class);
    }

    @JsonIgnore
    public String getNonPrefixId() {
        return Utils.removePagePrefix(this.getId());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonIgnore
    public boolean isLatestVersion() {
        return "latest".equals(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectedPage that = (SelectedPage)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public static class SelectedPages
    extends ArrayList<SelectedPage> {
        public boolean containsWithId(SelectedPage selectedPage) {
            for (SelectedPage s2 : this) {
                if (!s2.getId().equals(selectedPage.getId())) continue;
                return true;
            }
            return false;
        }

        public boolean containsWithIdAndVersion(SelectedPage selectedPage) {
            for (SelectedPage s2 : this) {
                if (!s2.getId().equals(selectedPage.getId()) || !s2.getVersion().equals(selectedPage.getVersion())) continue;
                return true;
            }
            return false;
        }
    }
}

