/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.utils;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.ArrayList;
import java.util.List;

public class PluginSettingsData {
    private final PluginSettings pluginSettings;
    private static final String PLUGIN_STORAGE_KEY = "tr.com.obss.plugin.baseline.plugin";
    private static final String ALL_USER_GROUPS_FOR_VIEW = "tr.com.obss.plugin.baseline.plugin".concat(".allUserGroupsForView");
    private static final String ALL_USER_GROUPS_FOR_EDIT = "tr.com.obss.plugin.baseline.plugin".concat(".allUserGroupsForEdit");
    private static final String ALL_USER_GROUPS_FOR_DELETE = "tr.com.obss.plugin.baseline.plugin".concat(".allUserGroupsForDelete");
    private static final String ALL_USER_GROUPS_FOR_EXPORT = "tr.com.obss.plugin.baseline.plugin".concat(".allUserGroupsForExport");
    private static final String SELECTED_GROUPS_FOR_VIEW = "tr.com.obss.plugin.baseline.plugin".concat(".selectedUserGroupForView");
    private static final String SELECTED_GROUPS_FOR_EDIT = "tr.com.obss.plugin.baseline.plugin".concat(".selectedUserGroupForEdit");
    private static final String SELECTED_GROUPS_FOR_DELETE = "tr.com.obss.plugin.baseline.plugin".concat(".selectedUserGroupForDelete");
    private static final String SELECTED_GROUPS_FOR_EXPORT = "tr.com.obss.plugin.baseline.plugin".concat(".selectedUserGroupForExport");

    public PluginSettingsData(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public Object getAllUserGroupsForView() {
        return this.pluginSettings.get(ALL_USER_GROUPS_FOR_VIEW);
    }

    public Object getAllUserGroupsForEdit() {
        return this.pluginSettings.get(ALL_USER_GROUPS_FOR_EDIT);
    }

    public Object getAllUserGroupsForDelete() {
        Object result = this.pluginSettings.get(ALL_USER_GROUPS_FOR_DELETE);
        if (result == null) {
            return this.getAllUserGroupsForEdit();
        }
        return result;
    }

    public Object getAllUserGroupsForExport() {
        return this.pluginSettings.get(ALL_USER_GROUPS_FOR_EXPORT);
    }

    public Object getUserGroupsForView() {
        return this.pluginSettings.get(SELECTED_GROUPS_FOR_VIEW);
    }

    public Object getUserGroupsForEdit() {
        return this.pluginSettings.get(SELECTED_GROUPS_FOR_EDIT);
    }

    public Object getUserGroupsForDelete() {
        Object result = this.pluginSettings.get(SELECTED_GROUPS_FOR_DELETE);
        if (result == null) {
            return this.getUserGroupsForEdit();
        }
        return result;
    }

    public Object getUserGroupsForExport() {
        return this.pluginSettings.get(SELECTED_GROUPS_FOR_EXPORT);
    }

    public void setAllUserGroupsForView(String value) {
        this.pluginSettings.put(ALL_USER_GROUPS_FOR_VIEW, (Object)value);
    }

    public void setAllUserGroupsForEdit(String value) {
        this.pluginSettings.put(ALL_USER_GROUPS_FOR_EDIT, (Object)value);
    }

    public void setAllUserGroupsForDelete(String value) {
        this.pluginSettings.put(ALL_USER_GROUPS_FOR_DELETE, (Object)value);
    }

    public void setAllUserGroupsForExport(String value) {
        this.pluginSettings.put(ALL_USER_GROUPS_FOR_EXPORT, (Object)value);
    }

    public void setUserGroupsForView(String value) {
        this.pluginSettings.put(SELECTED_GROUPS_FOR_VIEW, (Object)value);
    }

    public void setUserGroupsForEdit(String value) {
        this.pluginSettings.put(SELECTED_GROUPS_FOR_EDIT, (Object)value);
    }

    public void setUserGroupsForDelete(String value) {
        this.pluginSettings.put(SELECTED_GROUPS_FOR_DELETE, (Object)value);
    }

    public void setUserGroupsForExport(String value) {
        this.pluginSettings.put(SELECTED_GROUPS_FOR_EXPORT, (Object)value);
    }

    public String parameterValuesToString(String[] multiple) {
        StringBuilder sb = new StringBuilder();
        for (String pn : multiple) {
            sb.append(pn);
            sb.append(":;@");
        }
        return sb.toString().substring(0, sb.length() - 3);
    }

    public String parameterValuesToString(List<String> multiple) {
        StringBuilder sb = new StringBuilder();
        for (String pn : multiple) {
            sb.append(pn);
            sb.append("!!!");
        }
        return sb.toString().substring(0, sb.length() - 3);
    }

    public String createGeneralSettingString(List<String> fields) {
        String fs = "";
        if (fields.size() == 1) {
            fs = this.parameterValuesToString(fields);
            fs = fs.concat(":;@");
        } else if (fields.size() > 1) {
            fs = this.parameterValuesToString(fields);
        }
        return fs;
    }

    public List<String> stringToList(String str) {
        String[] array = str.split(":;@");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String spn : array) {
            arrayList.add(spn);
        }
        return arrayList;
    }

    public List<String> getUserGroupsForViewAsList() {
        List<String> selectedUserGroupsArrayList = new ArrayList<String>();
        String fsForView = this.getUserGroupsForView() == null ? "" : this.getUserGroupsForView().toString();
        String[] fsArrayForView = null;
        if (!"".equals(fsForView) && fsForView.length() > 1) {
            fsArrayForView = fsForView.split("!!!");
        }
        if (null != fsArrayForView && fsArrayForView.length >= 1) {
            String selectedUserGroupsForView = fsArrayForView[0];
            selectedUserGroupsArrayList = this.stringToList(selectedUserGroupsForView);
        }
        return selectedUserGroupsArrayList;
    }

    public List<String> getUserGroupsForEditAsList() {
        List<String> selectedUserGroupsArrayList = new ArrayList<String>();
        String fsForEdit = this.getUserGroupsForEdit() == null ? "" : this.getUserGroupsForEdit().toString();
        String[] fsArrayForEdit = null;
        if (!"".equals(fsForEdit) && fsForEdit.length() > 1) {
            fsArrayForEdit = fsForEdit.split("!!!");
        }
        if (null != fsArrayForEdit && fsArrayForEdit.length >= 1) {
            String selectedUserGroupsForEdit = fsArrayForEdit[0];
            selectedUserGroupsArrayList = this.stringToList(selectedUserGroupsForEdit);
        }
        return selectedUserGroupsArrayList;
    }

    public List<String> getUserGroupsForDeleteAsList() {
        List<String> selectedUserGroupsArrayList = new ArrayList<String>();
        String fsForDelete = this.getUserGroupsForDelete() == null ? "" : this.getUserGroupsForDelete().toString();
        String[] fsArrayForDelete = null;
        if (!"".equals(fsForDelete) && fsForDelete.length() > 1) {
            fsArrayForDelete = fsForDelete.split("!!!");
        }
        if (null != fsArrayForDelete && fsArrayForDelete.length >= 1) {
            String selectedUserGroupsForDelete = fsArrayForDelete[0];
            selectedUserGroupsArrayList = this.stringToList(selectedUserGroupsForDelete);
        }
        return selectedUserGroupsArrayList;
    }

    public List<String> getUserGroupsForExportAsList() {
        List<String> selectedUserGroupsArrayList = new ArrayList<String>();
        String fsForExport = this.getUserGroupsForExport() == null ? "" : this.getUserGroupsForExport().toString();
        String[] fsArrayForExport = null;
        if (!"".equals(fsForExport) && fsForExport.length() > 1) {
            fsArrayForExport = fsForExport.split("!!!");
        }
        if (null != fsArrayForExport && fsArrayForExport.length >= 1) {
            String selectedUserGroupsForExport = fsArrayForExport[0];
            selectedUserGroupsArrayList = this.stringToList(selectedUserGroupsForExport);
        }
        return selectedUserGroupsArrayList;
    }
}

