/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest.core.impl;

import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameterBuilder;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameters;
import tr.com.obss.plugin.baseline.request.BaselineCreateRequest;
import tr.com.obss.plugin.dto.BaselineCreateResult;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.rest.context.ResponseFactory;
import tr.com.obss.plugin.rest.core.BaselineRestServiceCore;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

public class BaselineRestServiceCoreImpl
implements BaselineRestServiceCore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineRestServiceCoreImpl.class);
    private final UserHasCondition userHasCondition;
    private final PluginLicenseManager licenseManager;
    private final BaselineService baselineService;
    private final AccessModeService accessModeService;
    private final Gson gson = new GsonBuilder().setFieldNamingStrategy(f -> f.getName().toLowerCase(Locale.ENGLISH)).create();

    public BaselineRestServiceCoreImpl(PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager licenseManager, BaselineService baselineService, AccessModeService accessModeService, UserAccessor userAccessor) {
        this.userHasCondition = new UserHasCondition(pluginSettingsFactory, userAccessor);
        this.licenseManager = licenseManager;
        this.baselineService = baselineService;
        this.accessModeService = accessModeService;
    }

    @Override
    public Object createBaseline(String requestBody, ResponseFactory responseFactory) {
        if (AuthenticatedUserThreadLocal.get() == null) {
            return responseFactory.status(403).entity("You are not authorized for this operation.").build();
        }
        if (!Utils.isLicenseValid(this.licenseManager)) {
            return responseFactory.status(403).entity("Your Baselines for Confluence license has expired.").build();
        }
        if (AccessMode.READ_ONLY == this.accessModeService.getAccessMode()) {
            return responseFactory.status(403).entity("Read-only mode is enabled. You cannot create baseline right now.").build();
        }
        Boolean isInEditGroups = this.userHasCondition.isInEditGroups(AuthenticatedUserThreadLocal.getUsername());
        if (!isInEditGroups.booleanValue()) {
            LOGGER.debug("user does not have permission to create baseline");
            return responseFactory.status(403).entity("unauthorized user").build();
        }
        try {
            BaselineCreateRequest baselineCreateRequest = this.gson.fromJson(requestBody, BaselineCreateRequest.class);
            BaselineCreateParameters parameters = new BaselineCreateParameterBuilder(baselineCreateRequest).build();
            BaselineCreateResult result = this.baselineService.createBaseline(parameters, baselineCreateRequest);
            return responseFactory.ok(result.getSuccessMessage()).build();
        }
        catch (BaselineParameterException e) {
            LOGGER.warn("BaselineParameterException", (Throwable)e);
            return responseFactory.badRequest(HtmlEscaper.escapeAll((String)e.getMessage(), (boolean)false)).build();
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception", (Throwable)e);
            return responseFactory.status(500).entity("an unexpected error has occurred").build();
        }
    }
}

