/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.html;

import com.atlassian.confluence.importexport.ImportExportException;
import net.sourceforge.htmlunit.cyberneko.parsers.DOMParser;
import net.sourceforge.htmlunit.xerces.dom.DocumentImpl;
import net.sourceforge.htmlunit.xerces.xni.parser.XMLDocumentFilter;
import net.sourceforge.htmlunit.xerces.xni.parser.XMLParserConfiguration;
import tr.com.obss.plugin.extra.flyingpdf.html.ConfluenceHtmlToXmlFilter;
import tr.com.obss.plugin.extra.flyingpdf.html.HtmlToDomParser;
import tr.com.obss.plugin.extra.flyingpdf.html.LinkFixer;

public class HtmlConverterUtils {
    public static final String STYLECOLLECTOR_KEY = "http://atlassian.com/html/properties/stylecollector";
    public static final String LINKFIXER_KEY = "http://atlassian.com/html/properties/linkfixer";

    public static HtmlToDomParser getHtmlToXhtmlParser(LinkFixer linkFixer) throws ImportExportException {
        DOMParser parser = new DOMParser(DocumentImpl.class);
        StringBuffer styleCollector = new StringBuffer();
        try {
            XMLParserConfiguration config = parser.getXMLParserConfiguration();
            config.addRecognizedFeatures(new String[]{"http://cyberneko.org/html/features/balance-tags", "http://cyberneko.org/html/features/override-doctype"});
            config.addRecognizedProperties(new String[]{STYLECOLLECTOR_KEY, LINKFIXER_KEY, "http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/default-encoding", "http://cyberneko.org/html/properties/filters", "http://cyberneko.org/html/properties/doctype/pubid", "http://cyberneko.org/html/properties/doctype/sysid"});
            config.setFeature("http://cyberneko.org/html/features/balance-tags", true);
            config.setFeature("http://cyberneko.org/html/features/override-doctype", true);
            config.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
            config.setProperty("http://cyberneko.org/html/properties/default-encoding", "UTF-8");
            config.setProperty("http://cyberneko.org/html/properties/doctype/pubid", "-//W3C//DTD XHTML 1.0 Transitional//EN");
            config.setProperty("http://cyberneko.org/html/properties/doctype/sysid", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
            config.setProperty("http://cyberneko.org/html/properties/filters", new XMLDocumentFilter[]{new ConfluenceHtmlToXmlFilter()});
            config.setProperty(STYLECOLLECTOR_KEY, styleCollector);
            config.setProperty(LINKFIXER_KEY, linkFixer);
        }
        catch (Exception ex) {
            throw new ImportExportException("Failed to configure HTML to XHTML parser", (Throwable)ex);
        }
        return new HtmlToDomParser(parser);
    }
}

