/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.config;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.util.GeneralUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import tr.com.obss.plugin.ExecutorResponse;
import tr.com.obss.plugin.VersionSpecificExecutor;
import tr.com.obss.plugin.extra.flyingpdf.config.FontManager;
import tr.com.obss.plugin.extra.flyingpdf.executor.VersionSpecificExecutorFactory;

public class ConfigurePDFLanguageSupportAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ConfigurePDFLanguageSupportAction.class);
    private FontManager pdfExportFontManager;
    private boolean installFontSuccess = false;

    public String execute() throws Exception {
        VersionSpecificExecutor executor = VersionSpecificExecutorFactory.getExecutor(GeneralUtil.getVersionNumber());
        ExecutorResponse response = executor.executeAction();
        if (response.getResult() != null && response.getResult().equals("success")) {
            try {
                this.pdfExportFontManager.installFont(response.getResource());
                return "success";
            }
            catch (IOException ex) {
                log.error("Unable to install custom font.", (Throwable)ex);
                return "error";
            }
        }
        return "error";
    }

    public String doRestoreDefault() {
        try {
            this.pdfExportFontManager.removeInstalledFont();
        }
        catch (IOException ex) {
            log.error("Unable to remove custom font.", (Throwable)ex);
            this.addActionError(ex.getMessage());
            return "error";
        }
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public String getInstalledFontName() {
        FileSystemResource fontResource = this.pdfExportFontManager.getInstalledFont();
        if (fontResource != null) {
            return fontResource.getFilename();
        }
        return null;
    }

    public boolean isInstallFontSuccess() {
        return this.installFontSuccess;
    }

    public void setInstallFontSuccess(boolean installFontSuccess) {
        this.installFontSuccess = installFontSuccess;
    }

    public void setPdfExportFontManager(FontManager pdfExportFontManager) {
        this.pdfExportFontManager = pdfExportFontManager;
    }
}

