/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.core.util.ProgressMeter;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.util.ErrorMessages;

public class SandboxProgressMonitor
implements PdfExportProgressMonitor {
    private static final int CONTENT_TREE_CALCULATION_PERCENTAGE = 4;
    private static final int HTML_CONVERSION_PERCENTAGE = 4;
    private final I18NBean i18NBean;
    private final ErrorMessages errorMessages;
    private final ProgressMeter progressMeter;
    private int numberOfPages;
    private int convertedPageCount = 0;

    public SandboxProgressMonitor(I18NBean bean, ErrorMessages errorMessages, ProgressMeter progressMeter) {
        this.i18NBean = bean;
        this.errorMessages = errorMessages;
        this.progressMeter = progressMeter;
    }

    @Override
    public void started() {
        this.progressMeter.setPercentage(0);
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.started"));
    }

    @Override
    public void beginCalculationOfContentTree() {
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.calculatecontenttree"));
    }

    @Override
    public void completedCalculationOfPdfPages(int numberOfPages) {
        this.numberOfPages = numberOfPages;
        this.convertedPageCount = 0;
    }

    @Override
    public void completedCalculationOfContentTree(int numberOfPages) {
        this.numberOfPages = numberOfPages;
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.contenttreecalculated"));
        this.progressMeter.setPercentage(4);
    }

    private static double getPercentage(double progress, double total) {
        return progress * 100.0 / total;
    }

    private static double scalePercentage(double originalPercentage, double scalingFactor) {
        return scalingFactor / 100.0 * originalPercentage;
    }

    @Override
    public void completedExportedHtmlConversionForPage(String pageId, String pageTitle) {
        ++this.convertedPageCount;
        double percentageComplete = SandboxProgressMonitor.getPercentage(this.convertedPageCount, this.numberOfPages);
        double weightedPercentageComplete = SandboxProgressMonitor.scalePercentage(percentageComplete, 4.0) + 4.0;
        this.progressMeter.setPercentage((int)weightedPercentageComplete);
        String message = this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.pageConvertedToHtml", (Object[])new String[]{String.valueOf(this.convertedPageCount), String.valueOf(this.numberOfPages)});
        this.progressMeter.setStatus(message);
    }

    @Override
    public void beginHtmlToPdfConversion() {
        this.convertedPageCount = 0;
        this.progressMeter.setPercentage(8);
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.beginhtmltopdf"));
    }

    @Override
    public void performingHtmlToPdfConversionForPage(String pageTitle) {
        int pdfConversionPercentage;
        ++this.convertedPageCount;
        double percentageComplete = SandboxProgressMonitor.getPercentage(this.convertedPageCount, this.numberOfPages);
        double weightedPercentageComplete = SandboxProgressMonitor.scalePercentage(percentageComplete, pdfConversionPercentage = 92) + 4.0 + 4.0;
        int calculatedPercentage = (int)weightedPercentageComplete;
        if (calculatedPercentage > 99) {
            calculatedPercentage = 99;
        }
        this.progressMeter.setPercentage(calculatedPercentage);
        String message = this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.pageConvertedToPdf", (Object[])new String[]{String.valueOf(this.convertedPageCount), String.valueOf(this.numberOfPages)});
        this.progressMeter.setStatus(message);
    }

    @Override
    public void completed(String downloadPath) {
        this.progressMeter.setCompletedSuccessfully(true);
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.completed", (Object[])new String[]{downloadPath}));
        this.progressMeter.setPercentage(100);
    }

    @Override
    public void errored(String exceptionMessage) {
        this.progressMeter.setCompletedSuccessfully(false);
        this.progressMeter.setStatus(exceptionMessage);
    }
}

