/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.context;

import javax.ws.rs.core.Response;
import tr.com.obss.plugin.rest.context.HttpResponseAdapter;
import tr.com.obss.plugin.rest.context.ResponseFactory;

public class JavaxResponseFactory
implements ResponseFactory {
    @Override
    public HttpResponseAdapter ok() {
        return new JavaxResponseAdapter(Response.ok());
    }

    @Override
    public HttpResponseAdapter ok(Object entity) {
        return new JavaxResponseAdapter(Response.ok((Object)entity));
    }

    @Override
    public HttpResponseAdapter badRequest() {
        return new JavaxResponseAdapter(Response.status((Response.Status)Response.Status.BAD_REQUEST));
    }

    @Override
    public HttpResponseAdapter badRequest(Object entity) {
        return new JavaxResponseAdapter(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(entity));
    }

    @Override
    public HttpResponseAdapter status(int status) {
        return new JavaxResponseAdapter(Response.status((int)status));
    }

    private static class JavaxResponseAdapter
    implements HttpResponseAdapter {
        private final Response.ResponseBuilder builder;

        public JavaxResponseAdapter(Response.ResponseBuilder builder) {
            this.builder = builder;
        }

        @Override
        public HttpResponseAdapter type(String mediaType) {
            if ("application/json".equals(mediaType)) {
                this.builder.type("application/json");
            } else if ("text/plain".equals(mediaType)) {
                this.builder.type("text/plain");
            } else if ("text/html".equals(mediaType)) {
                this.builder.type("text/html");
            } else {
                this.builder.type(mediaType);
            }
            return this;
        }

        @Override
        public HttpResponseAdapter entity(Object entity) {
            this.builder.entity(entity);
            return this;
        }

        @Override
        public HttpResponseAdapter header(String name, Object value) {
            this.builder.header(name, value);
            return this;
        }

        @Override
        public HttpResponseAdapter status(int status) {
            this.builder.status(status);
            return this;
        }

        @Override
        public Object build() {
            return this.builder.build();
        }
    }
}

