/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CsvFileContent {
    private final List<String> columnHeaders;
    private final List<List<String>> rows = new ArrayList<List<String>>();

    public CsvFileContent(List<String> columnHeaders) {
        if (Objects.isNull(columnHeaders) || columnHeaders.isEmpty()) {
            throw new IllegalArgumentException("'columnHeaders' must not be null or empty");
        }
        this.columnHeaders = columnHeaders;
    }

    public void addRow(List<String> row) {
        if (row != null) {
            this.rows.add(row);
        }
    }

    public void addRows(List<List<String>> rows) {
        this.rows.addAll(rows);
    }

    public List<String> getColumnHeaders() {
        return this.columnHeaders;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvFileContent)) {
            return false;
        }
        CsvFileContent that = (CsvFileContent)o;
        if (!this.getColumnHeaders().equals(that.getColumnHeaders())) {
            return false;
        }
        return this.getRows().equals(that.getRows());
    }

    public int hashCode() {
        return Objects.hash(this.columnHeaders, this.rows);
    }
}

