/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest.core.impl;

import com.atlassian.json.jsonorg.JSONObject;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.progress.BaselineProgressTracker;
import tr.com.obss.plugin.rest.context.ResponseFactory;
import tr.com.obss.plugin.rest.core.BaselineProgressRestServiceCore;

public class BaselineProgressRestServiceCoreImpl
implements BaselineProgressRestServiceCore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineProgressRestServiceCoreImpl.class);

    @Override
    public Object getProgress(String operationIdAsString, ResponseFactory responseFactory) {
        UUID operationId = null;
        try {
            operationId = UUID.fromString(operationIdAsString);
        }
        catch (Exception e) {
            LOGGER.error("Invalid operationId for progress tracking. operationId: {}", (Object)operationIdAsString);
        }
        JSONObject data = new JSONObject();
        data.put("isFailed", BaselineProgressTracker.isFailed(operationId));
        data.put("percentageComplete", BaselineProgressTracker.getCurrentPercentage(operationId));
        return responseFactory.ok(data.toString()).type("application/json").build();
    }
}

