/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.progress;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.progress.BaselineProgress;

public final class BaselineProgressTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineProgressTracker.class);
    private static final int MAX_HOURS = 72;
    private static final int MS_TO_HOUR_DIV = 3600000;
    private static final AtomicBoolean clearing = new AtomicBoolean(false);
    private static final Map<UUID, BaselineProgress> PROGRESS_MAP = new ConcurrentHashMap<UUID, BaselineProgress>();

    private BaselineProgressTracker() {
    }

    public static boolean exists(UUID operationId) {
        return PROGRESS_MAP.containsKey(operationId);
    }

    public static void addProgress(UUID operationId, BaselineProgress baselineProgress) {
        BaselineProgressTracker.clearOldProgresses();
        PROGRESS_MAP.put(operationId, baselineProgress);
    }

    public static BaselineProgress getProgress(UUID operationId) {
        if (operationId != null && BaselineProgressTracker.exists(operationId)) {
            return PROGRESS_MAP.get(operationId);
        }
        return null;
    }

    public static int getCurrentPercentage(UUID operationId) {
        if (operationId == null) {
            return 0;
        }
        BaselineProgress baselineProgress = PROGRESS_MAP.get(operationId);
        return baselineProgress != null ? baselineProgress.getCurrentPercentage() : 0;
    }

    public static boolean isFailed(UUID operationId) {
        if (operationId == null) {
            return false;
        }
        BaselineProgress baselineProgress = PROGRESS_MAP.get(operationId);
        return baselineProgress != null && baselineProgress.isFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearOldProgresses() {
        if (!clearing.compareAndSet(false, true)) {
            return;
        }
        try {
            Iterator<Map.Entry<UUID, BaselineProgress>> iterator = PROGRESS_MAP.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, BaselineProgress> entry = iterator.next();
                long startTime = entry.getValue().getStartTime();
                long diff = System.currentTimeMillis() - startTime;
                int hours = (int)(diff / 3600000L);
                if (hours < 72) continue;
                iterator.remove();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while clearing progress map.", (Throwable)e);
        }
        finally {
            clearing.set(false);
        }
    }
}

