/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.migration;

import com.atlassian.migration.app.PaginatedMapping;
import com.atlassian.migration.app.gateway.AppCloudForgeMigrationGateway;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import tr.com.obss.plugin.migration.MigrationMappingsService;

public class MigrationMappingsServiceImpl
implements MigrationMappingsService {
    private static final String NAMESPACE_SPACE = "confluence:space";
    private static final String NAMESPACE_PAGE = "confluence:page";
    private static final String NAMESPACE_ATTACHMENT = "confluence:attachment";
    private static final String NAMESPACE_GROUP = "identity:group";
    private static final String GROUP_NAME_PREFIX = "identity:group:name/";
    private final AppCloudForgeMigrationGateway appCloudMigrationGateway;

    public MigrationMappingsServiceImpl(AppCloudForgeMigrationGateway appCloudMigrationGateway) {
        this.appCloudMigrationGateway = appCloudMigrationGateway;
    }

    @Override
    public Map<String, String> getSpaceMappings() {
        return this.getAllAvailableMappingsForNamespace(NAMESPACE_SPACE);
    }

    @Override
    public Map<String, String> getPageMappings() {
        return this.getAllAvailableMappingsForNamespace(NAMESPACE_PAGE);
    }

    @Override
    public Map<String, String> getAttachmentMappings() {
        return this.getAllAvailableMappingsForNamespace(NAMESPACE_ATTACHMENT);
    }

    @Override
    public Map<String, String> getGroupMappings() {
        return this.getAllAvailableMappingsForNamespace(NAMESPACE_GROUP).entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(GROUP_NAME_PREFIX)).collect(Collectors.toMap(e -> ((String)e.getKey()).split("/")[1], Map.Entry::getValue, (oldValue, newValue) -> newValue));
    }

    private Map<String, String> getAllAvailableMappingsForNamespace(String namespace) {
        PaginatedMapping paginatedMapping = this.appCloudMigrationGateway.getPaginatedMapping(namespace, 1200);
        HashMap<String, String> mappings = new HashMap<String, String>();
        while (paginatedMapping.next()) {
            Map<String, String> _mappings = paginatedMapping.getMapping();
            mappings.putAll(_mappings);
        }
        return mappings;
    }
}

