/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.migration;

import com.atlassian.confluence.spaces.Space;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentType;
import tr.com.obss.plugin.migration.MigrationMappingResult;
import tr.com.obss.plugin.migration.export.BaselineExport;

public class BaselineMappingHandler {
    private final Space space;
    private final Map<String, String> spaceMappings;
    private final Map<String, String> pageMappings;
    private final Map<String, String> attachmentMappings;

    public BaselineMappingHandler(Space space, Map<String, String> spaceMappings, Map<String, String> pageMappings, Map<String, String> attachmentMappings) {
        this.space = space;
        this.spaceMappings = spaceMappings;
        this.pageMappings = pageMappings;
        this.attachmentMappings = attachmentMappings;
    }

    public BaselineExport handle(Baseline source) {
        BaselineExport export = new BaselineExport();
        ArrayList<MigrationMappingResult.Error> errors = new ArrayList<MigrationMappingResult.Error>();
        export.setName(source.getName());
        export.setId(this.generateBaselineId(source.getName()));
        MigrationMappingResult<String> spaceKeyMapping = this.mapSpaceKey();
        export.setSpaceId(spaceKeyMapping.getMappedValue());
        if (!spaceKeyMapping.getErrors().isEmpty()) {
            errors.addAll(spaceKeyMapping.getErrors());
        }
        export.setBaselineDate(source.getBaselineDate().toInstant().toString());
        export.setCreatedAt(source.getCreationDate().toInstant().toString());
        export.setContents(new ArrayList<BaselineExport.BaselineContent>());
        for (BaselineDocument doc : source.getAllDocuments()) {
            BaselineExport.BaselineContent content = new BaselineExport.BaselineContent();
            MigrationMappingResult<String> documentIdMapping = this.mapDocumentId(doc.getId(), doc.getType());
            content.setId(documentIdMapping.getMappedValue());
            errors.addAll(documentIdMapping.getErrors());
            content.setTitle(doc.getTitle());
            content.setPath(doc.getPath());
            content.setVersion(doc.getVersion());
            MigrationMappingResult<String> urlMapping = this.mapDocumentUrl(doc.getId(), doc.getUrl(), doc.getType());
            content.setUrl(urlMapping.getMappedValue());
            errors.addAll(urlMapping.getErrors());
            content.setVersionCreatedAt(doc.getCreationDate().toInstant().toString());
            content.setType(doc.getType() == BaselineDocumentType.PAGE ? "page" : "attachment");
            export.getContents().add(content);
        }
        return export;
    }

    private MigrationMappingResult<String> mapSpaceKey() {
        String spaceIdAtServer = String.valueOf(this.space.getId());
        if (this.spaceMappings.containsKey(spaceIdAtServer)) {
            return new MigrationMappingResult<String>(this.spaceMappings.get(spaceIdAtServer));
        }
        return new MigrationMappingResult<String>(spaceIdAtServer, new MigrationMappingResult.Error("projectKey", spaceIdAtServer));
    }

    private MigrationMappingResult<String> mapDocumentId(String documentId, BaselineDocumentType type) {
        if (type == BaselineDocumentType.PAGE) {
            if (this.pageMappings.containsKey(documentId)) {
                return new MigrationMappingResult<String>(this.pageMappings.get(documentId));
            }
            return new MigrationMappingResult<String>(documentId, new MigrationMappingResult.Error("pageId", documentId));
        }
        if (type == BaselineDocumentType.ATTACHMENT) {
            if (this.attachmentMappings.containsKey(documentId)) {
                return new MigrationMappingResult<String>(this.attachmentMappings.get(documentId));
            }
            return new MigrationMappingResult<String>(documentId, new MigrationMappingResult.Error("attachmentId", documentId));
        }
        throw new UnsupportedOperationException("Unknown document type: " + (Object)((Object)type));
    }

    private MigrationMappingResult<String> mapDocumentUrl(String documentIdOnServer, String documentUrl, BaselineDocumentType type) {
        String documentIdOnCloud;
        if (documentUrl == null) {
            return new MigrationMappingResult<Object>(null);
        }
        String string = documentIdOnCloud = type == BaselineDocumentType.PAGE ? (String)this.pageMappings.getOrDefault(documentIdOnServer, null) : (String)this.attachmentMappings.getOrDefault(documentIdOnServer, null);
        if (documentIdOnCloud == null) {
            return new MigrationMappingResult<String>(documentUrl, new MigrationMappingResult.Error("url", documentUrl));
        }
        String mappedUrl = documentUrl.replace(documentIdOnServer, documentIdOnCloud);
        return new MigrationMappingResult<String>(mappedUrl);
    }

    private String generateBaselineId(String baselineName) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md.digest(baselineName.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not available", e);
        }
    }
}

