/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.info;

import com.atlassian.plugin.PluginAccessor;
import tr.com.obss.plugin.info.InfoService;
import tr.com.obss.plugin.utils.ConfigUtils;

public class InfoServiceImpl
implements InfoService {
    private static final String ALLOWED_PDF_MAX_PAGE_COUNT = "baselines.export.pdf.maxpagecount";
    private static final int ALLOWED_PDF_MAX_PAGE_COUNT_DEFAULT = -1;
    private static final String BASELINE_CONTENT_PAGE_SIZE = "baselines.persistence.content.pagesize";
    private static final int BASELINE_CONTENT_PAGE_SIZE_DEFAULT = 100000;
    private static final String COMPRESS_BASELINE_CONTENT = "baselines.persistence.content.compress";
    private static final boolean COMPRESS_BASELINE_CONTENT_DEFAULT = true;
    public static final String PLUGIN_KEY = "tr.com.obss.plugin.confluence-baseline-plugin";
    private ConfigUtils configUtils;
    private PluginAccessor pluginAccessor;

    public InfoServiceImpl(ConfigUtils configUtils, PluginAccessor pluginAccessor) {
        this.configUtils = configUtils;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public int getAllowedPdfMaxPageCount() {
        return this.configUtils.readIntPropertyValue(ALLOWED_PDF_MAX_PAGE_COUNT, -1);
    }

    @Override
    public int getBaselineContentPageSize() {
        return this.configUtils.readIntPropertyValue(BASELINE_CONTENT_PAGE_SIZE, 100000);
    }

    @Override
    public boolean compressBaselineContent() {
        return this.configUtils.readBooleanPropertyValue(COMPRESS_BASELINE_CONTENT, true);
    }

    @Override
    public String getPluginVersion() {
        return this.pluginAccessor.getPlugin(PLUGIN_KEY).getPluginInformation().getVersion();
    }
}

