/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.dto.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineAttachment;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentType;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.dto.BaselinePage;
import tr.com.obss.plugin.dto.impl.BaselineSummaryImpl;
import tr.com.obss.plugin.exception.UnhandledEnumValueException;

public class BaselineImpl
extends BaselineSummaryImpl
implements Baseline {
    private String spaceKey;
    private String creator;
    private String keyword;
    private Map<String, BaselinePage> pagesById;
    private List<BaselineDocument> allDocuments;
    private List<BaselineDocument> pageDocuments;
    private List<BaselineDocument> attachmentDocuments;
    private final int totalPageCount;
    private final int totalAttachmentCount;
    private final boolean isPaginated;

    public BaselineImpl(String name, Date creationDate, Date baselineDate, String spaceKey, String creator, String keyword, int totalPageCount, int totalAttachmentCount, List<BaselineDocument> paginatedDocuments) {
        super(name, baselineDate, creationDate);
        this.spaceKey = spaceKey;
        this.creator = creator;
        this.keyword = keyword;
        this.totalPageCount = totalPageCount;
        this.totalAttachmentCount = totalAttachmentCount;
        this.generateDocumentCollections(paginatedDocuments);
        this.isPaginated = true;
    }

    public BaselineImpl(String name, Date creationDate, Date baselineDate, String spaceKey, String creator, String keyword, List<BaselineDocument> documents) {
        super(name, baselineDate, creationDate);
        this.spaceKey = spaceKey;
        this.creator = creator;
        this.keyword = keyword;
        this.generateDocumentCollections(documents);
        this.totalPageCount = this.pageDocuments.size();
        this.totalAttachmentCount = this.attachmentDocuments.size();
        this.isPaginated = false;
    }

    private void generateDocumentCollections(List<BaselineDocument> documents) {
        this.allDocuments = documents;
        this.pagesById = new HashMap<String, BaselinePage>();
        this.pageDocuments = new ArrayList<BaselineDocument>();
        this.attachmentDocuments = new ArrayList<BaselineDocument>();
        if (documents == null) {
            this.allDocuments = new ArrayList<BaselineDocument>();
            return;
        }
        for (BaselineDocument document : documents) {
            if (document.getType() == BaselineDocumentType.PAGE) {
                BaselinePage page = (BaselinePage)document;
                this.pagesById.put(page.getId(), page);
                this.pageDocuments.add(page);
                continue;
            }
            if (document.getType() != BaselineDocumentType.ATTACHMENT) continue;
            this.attachmentDocuments.add(document);
        }
    }

    @Override
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public Set<String> getPageIds() {
        HashSet<String> pageIds = new HashSet<String>();
        for (BaselineDocument document : this.pageDocuments) {
            pageIds.add(document.getId());
        }
        for (BaselineDocument document : this.attachmentDocuments) {
            pageIds.add(((BaselineAttachment)document).getPageId());
        }
        return pageIds;
    }

    @Override
    public List<BaselinePage> getPages() {
        return new ArrayList<BaselinePage>(this.pagesById.values());
    }

    @Override
    public List<BaselineDocument> getAllDocuments() {
        return this.allDocuments;
    }

    @Override
    public List<BaselineDocument> getPageDocuments() {
        return this.pageDocuments;
    }

    @Override
    public List<BaselineDocument> getAttachmentDocuments() {
        return this.attachmentDocuments;
    }

    @Override
    public int getTotalPageCount() {
        return this.totalPageCount;
    }

    @Override
    public int getTotalAttachmentCount() {
        return this.totalAttachmentCount;
    }

    @Override
    public int getTotalDocumentCount() {
        return this.getTotalPageCount() + this.getTotalAttachmentCount();
    }

    @Override
    public int getTotalDocumentCountByType(BaselineDocumentTypeQuery documentType) throws UnhandledEnumValueException {
        if (BaselineDocumentTypeQuery.PAGE.equals((Object)documentType)) {
            return this.getTotalPageCount();
        }
        if (BaselineDocumentTypeQuery.ATTACHMENT.equals((Object)documentType)) {
            return this.getTotalAttachmentCount();
        }
        if (BaselineDocumentTypeQuery.ANY_DOCUMENT.equals((Object)documentType)) {
            return this.getTotalDocumentCount();
        }
        throw new UnhandledEnumValueException();
    }

    @Override
    public int getTotalDocumentCountByTypeStr(String documentType) throws UnhandledEnumValueException {
        return this.getTotalDocumentCountByType(BaselineDocumentTypeQuery.getByValue(documentType));
    }

    @Override
    public BaselinePage getPageById(String pageId) {
        return this.pagesById.get(pageId);
    }

    @Override
    public boolean isPaginated() {
        return this.isPaginated;
    }
}

