/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import tr.com.obss.plugin.VersionSpecificPermissionManager;
import tr.com.obss.plugin.VersionSpecificPermissionService;

public class Confluence7And8And9PermissionService
implements VersionSpecificPermissionService {
    private final SpaceManager spaceManager;
    private final VersionSpecificPermissionManager permissionManager;

    public Confluence7And8And9PermissionService(SpaceManager spaceManager, VersionSpecificPermissionManager permissionManager) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean userCanViewSpace(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.userCanViewSpace(space);
    }

    @Override
    public boolean userCanViewSpace(Space space) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (space == null) {
            return false;
        }
        return this.permissionManager.hasPermission((Object)confluenceUser, Permission.VIEW, space);
    }

    @Override
    public boolean userCanExportSpace(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.userCanExportSpace(space);
    }

    @Override
    public boolean userCanExportSpace(Space space) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (space == null) {
            return false;
        }
        return this.permissionManager.hasPermission((Object)confluenceUser, Permission.EXPORT, space);
    }
}

