/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import javax.inject.Inject;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.context.JakartaHttpRequestAdapter;
import tr.com.obss.plugin.context.JakartaResponseFactory;
import tr.com.obss.plugin.date.BaselineDateService;
import tr.com.obss.plugin.rest.PagesService;
import tr.com.obss.plugin.rest.core.PagesServiceCore;
import tr.com.obss.plugin.rest.core.impl.PagesServiceCoreImpl;

@Path(value="/pageService")
public class JakartaPagesService
implements PagesService<HttpServletRequest, Response> {
    private final PagesServiceCore core;
    private final JakartaResponseFactory responseFactory;

    @Inject
    public JakartaPagesService(SpaceManager spaceManager, PageManager pageManager, TemplateRenderer templateRenderer, PluginSettingsFactory pluginSettingsFactory, BaselineDateService dateService, BaselineService baselineService, PermissionManager permissionManager, UserAccessor userAccessor) {
        this.core = new PagesServiceCoreImpl(spaceManager, pageManager, templateRenderer, pluginSettingsFactory, dateService, baselineService, permissionManager, userAccessor);
        this.responseFactory = new JakartaResponseFactory();
    }

    @Override
    @GET
    @Path(value="/getsubpagesofpage")
    public Response getSubpagesOfPage(@Context HttpServletRequest req) {
        return (Response)this.core.getSubpagesOfPage(new JakartaHttpRequestAdapter(req), this.responseFactory);
    }

    @Override
    @GET
    @Path(value="/getBelongingBaselines")
    public Response getBelongingBaselines(@Context HttpServletRequest req) {
        return (Response)this.core.getBelongingBaselines(new JakartaHttpRequestAdapter(req), this.responseFactory);
    }

    @Override
    @GET
    @Path(value="/gettoplevelpagesforspace")
    public Response getTopLevelPagesForSpace(@Context HttpServletRequest req) {
        return (Response)this.core.getTopLevelPagesForSpace(new JakartaHttpRequestAdapter(req), this.responseFactory);
    }

    @Override
    @GET
    @Path(value="/renderTreeComponent")
    public Response renderTreeComponent(@Context HttpServletRequest req) {
        return (Response)this.core.renderTreeComponent(new JakartaHttpRequestAdapter(req), this.responseFactory);
    }
}

