/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.migration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.migration.BaselineMappingHandler;
import tr.com.obss.plugin.migration.MigrationDataExportService;
import tr.com.obss.plugin.migration.MigrationMappingsService;
import tr.com.obss.plugin.migration.export.BaselineExport;
import tr.com.obss.plugin.migration.export.PluginSettingsExport;
import tr.com.obss.plugin.utils.PluginSettingsData;

public class MigrationDataExportServiceImpl
implements MigrationDataExportService {
    private final PluginSettingsFactory pluginSettingsFactory;
    private final BaselineService baselineService;
    private final SpaceManager spaceManager;

    public MigrationDataExportServiceImpl(PluginSettingsFactory pluginSettingsFactory, SpaceManager spaceManager, BaselineService baselineService) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.spaceManager = spaceManager;
        this.baselineService = baselineService;
    }

    @Override
    public PluginSettingsExport preparePluginSettingsExport(MigrationMappingsService migrationMappingsService) {
        PluginSettingsData pluginSettingsData = new PluginSettingsData(this.pluginSettingsFactory);
        Map<String, String> groupMappings = migrationMappingsService.getGroupMappings();
        List<String> selectedGroupNamesForView = this.mapAllGroupNames(groupMappings, pluginSettingsData.getUserGroupsForViewAsList());
        List<String> selectedGroupNamesForEdit = this.mapAllGroupNames(groupMappings, pluginSettingsData.getUserGroupsForEditAsList());
        List<String> selectedGroupNamesForDelete = this.mapAllGroupNames(groupMappings, pluginSettingsData.getUserGroupsForDeleteAsList());
        List<String> selectedGroupNamesForExport = this.mapAllGroupNames(groupMappings, pluginSettingsData.getUserGroupsForExportAsList());
        return new PluginSettingsExport(selectedGroupNamesForView, selectedGroupNamesForEdit, selectedGroupNamesForDelete, selectedGroupNamesForExport);
    }

    private List<String> mapAllGroupNames(Map<String, String> groupMappings, List<String> groupNames) {
        return groupNames.stream().map(groupNameOnServer -> groupMappings.getOrDefault(groupNameOnServer, null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<BaselineExport> prepareBaselinesExport(MigrationMappingsService migrationMappingsService) {
        ArrayList<BaselineExport> baselineExports = new ArrayList<BaselineExport>();
        Map<String, String> spaceMappings = migrationMappingsService.getSpaceMappings();
        Map<String, String> pageMappings = migrationMappingsService.getPageMappings();
        Map<String, String> attachmentMappings = migrationMappingsService.getAttachmentMappings();
        Collection allSpaceKeys = this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT);
        for (String spaceKey : allSpaceKeys) {
            Space space = this.spaceManager.getSpace(spaceKey);
            BaselineMappingHandler mappingHandler = new BaselineMappingHandler(space, spaceMappings, pageMappings, attachmentMappings);
            List<String> baselineNamesOfSpace = this.baselineService.getBaselineNames(space);
            for (String baselineName : baselineNamesOfSpace) {
                Baseline bsl = this.baselineService.getBaseline(space, baselineName, BaselineDocumentTypeQuery.ANY_DOCUMENT);
                baselineExports.add(mappingHandler.handle(bsl));
            }
        }
        return baselineExports;
    }
}

