/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import tr.com.obss.plugin.VersionSpecificPermissionManager;
import tr.com.obss.plugin.extra.flyingpdf.manager.PermissionManagerFactory;

@Internal
public class ExportPermissionChecker {
    private VersionSpecificPermissionManager permissionManager;

    public ExportPermissionChecker(PermissionManager permissionManager) {
        this.permissionManager = PermissionManagerFactory.getPermissionManager(permissionManager);
    }

    public void checkAuthorization(User user, Object target) {
        boolean permitted = false;
        if (target instanceof Space) {
            permitted = this.isPermitted(user, (Space)target);
        } else if (target instanceof AbstractPage) {
            permitted = this.isPermitted(user, (AbstractPage)target);
        }
        if (!permitted) {
            String username = user == null ? "anonymous" : user.getName();
            throw new NotAuthorizedException("The user " + username + " is not permitted to perform this export");
        }
    }

    public boolean isPermitted(User user, AbstractPage page) {
        return this.permissionManager.hasPermission((Object)user, Permission.VIEW, page);
    }

    public boolean isPermitted(User user, Space space) {
        return this.permissionManager.isConfluenceAdministrator(user) || this.permissionManager.hasPermission((Object)user, Permission.EXPORT, space);
    }
}

