/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.baseline.request;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameters;
import tr.com.obss.plugin.baseline.request.SingleOrArrayListTypeAdapterFactory;
import tr.com.obss.plugin.dto.SelectedPage;
import tr.com.obss.plugin.pojo.DateTypeAdapter;

public class BaselineCreateRequest {
    @SerializedName(value="spaceKey", alternate={"space-key"})
    private String spaceKey;
    @SerializedName(value="baselineName", alternate={"baseline-name"})
    private String baselineName;
    @SerializedName(value="creationType", alternate={"creation-type"})
    private String creationType;
    @SerializedName(value="baselineDate", alternate={"baseline-date"})
    private String baselineDate;
    @Deprecated
    @SerializedName(value="dateField", alternate={"date-field"})
    private String dateField;
    @SerializedName(value="baselineKeyword", alternate={"baseline-keyword"})
    private String baselineKeyword;
    private String selectAllPages;
    private List<SelectedPage> fullySelectedPages;
    private List<SelectedPage> partiallySelectedPages;
    private String operationId;

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getBaselineName() {
        return this.baselineName;
    }

    public void setBaselineName(String baselineName) {
        this.baselineName = baselineName;
    }

    public String getCreationType() {
        return this.creationType;
    }

    public void setCreationType(String creationType) {
        this.creationType = creationType;
    }

    public String getBaselineDate() {
        return this.baselineDate;
    }

    public void setBaselineDate(String baselineDate) {
        this.baselineDate = baselineDate;
    }

    public String getDateField() {
        return this.dateField;
    }

    public void setDateField(String dateField) {
        this.dateField = dateField;
    }

    public String getBaselineKeyword() {
        return this.baselineKeyword;
    }

    public void setBaselineKeyword(String baselineKeyword) {
        this.baselineKeyword = baselineKeyword;
    }

    public String getSelectAllPages() {
        return this.selectAllPages;
    }

    public void setSelectAllPages(String selectAllPages) {
        this.selectAllPages = selectAllPages;
    }

    public void setFullySelectedPages(List<SelectedPage> fullySelectedPages) {
        this.fullySelectedPages = fullySelectedPages;
    }

    public List<SelectedPage> getFullySelectedPages() {
        return this.fullySelectedPages;
    }

    public void setPartiallySelectedPages(List<SelectedPage> partiallySelectedPages) {
        this.partiallySelectedPages = partiallySelectedPages;
    }

    public List<SelectedPage> getPartiallySelectedPages() {
        return this.partiallySelectedPages;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public static BaselineCreateRequest fromRequestParameters(Map<?, ?> requestParameters) {
        HashMap<String, String> createRequestParams = new HashMap<String, String>();
        requestParameters.keySet().forEach(key -> {
            if (key instanceof String) {
                String parameterName = ((String)key).trim();
                if (BaselineCreateParameters.getParameterNamesAsList().contains(parameterName)) {
                    createRequestParams.put(parameterName, ((String[])requestParameters.get(key))[0]);
                }
            }
        });
        Gson gsonLocal = new GsonBuilder().registerTypeAdapterFactory(new SingleOrArrayListTypeAdapterFactory()).registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter()).create();
        JsonElement jsonTree = gsonLocal.toJsonTree(createRequestParams);
        BaselineCreateRequest baselineCreateRequest = gsonLocal.fromJson(jsonTree, BaselineCreateRequest.class);
        if (createRequestParams.get("partiallySelectedPages") != null) {
            List<SelectedPage> partiallySelectedPages = BaselineCreateRequest.createSelectedPages(createRequestParams, "partiallySelectedPages");
            baselineCreateRequest.setPartiallySelectedPages(partiallySelectedPages);
        }
        if (createRequestParams.get("fullySelectedPages") != null) {
            List<SelectedPage> fullySelectedPages = BaselineCreateRequest.createSelectedPages(createRequestParams, "fullySelectedPages");
            baselineCreateRequest.setFullySelectedPages(fullySelectedPages);
        }
        return baselineCreateRequest;
    }

    private static List<SelectedPage> createSelectedPages(Map<String, String> createRequestParams, String input) {
        ArrayList<SelectedPage> selectedPages = new ArrayList<SelectedPage>();
        JSONArray jsonArray = new JSONArray(createRequestParams.get(input));
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject.has("id") && jsonObject.has("version")) {
                selectedPages.add(new SelectedPage((String)jsonObject.get("id"), (String)jsonObject.get("version")));
                continue;
            }
            if (jsonObject.has("id")) {
                selectedPages.add(new SelectedPage((String)jsonObject.get("id")));
                continue;
            }
            selectedPages.add(new SelectedPage());
        }
        return selectedPages;
    }

    public String toString() {
        return "BaselineCreateParametersTemp{spaceKey='" + this.spaceKey + '\'' + ", baselineName='" + this.baselineName + '\'' + ", creationType='" + this.creationType + '\'' + ", baselineDate='" + this.baselineDate + '\'' + ", dateField='" + this.dateField + '\'' + ", keywords='" + this.baselineKeyword + '\'' + ", selectAllPages='" + this.selectAllPages + '\'' + ", fullySelectedPages='" + this.fullySelectedPages + '\'' + ", partiallySelectedPages='" + this.partiallySelectedPages + '\'' + ", operationId='" + this.operationId + '\'' + '}';
    }
}

