/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.baseline.parameter;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import java.util.List;
import java.util.UUID;
import tr.com.obss.plugin.ServiceAccessor;
import tr.com.obss.plugin.baseline.parameter.BaselineParameterBuilder;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.dto.BaselinePage;
import tr.com.obss.plugin.exception.BaselineNotFoundException;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.exception.InvalidBaselineNamesToCompareException;
import tr.com.obss.plugin.progress.BaselineProgressPhaseType;
import tr.com.obss.plugin.progress.BaselineProgressTracker;
import tr.com.obss.plugin.progress.PhasedBaselineProgress;

public class BaselineCompareParameterBuilder
extends BaselineParameterBuilder {
    private String[] selectedBaselinesParam;

    public BaselineCompareParameterBuilder(String operationIdParam, String spaceKeyParam, String[] selectedBaselinesParam) {
        super(operationIdParam, spaceKeyParam);
        this.selectedBaselinesParam = selectedBaselinesParam;
    }

    public BaselineCompareParameters build() throws BaselineParameterException {
        UUID operationId = this.validateOperationId();
        PhasedBaselineProgress baselineProgress = this.generateProgress(operationId);
        Space space = this.validateSpace();
        this.validateSelectedBaselineNames(this.selectedBaselinesParam);
        Baseline[] baselines = this.validateBaselines(space, baselineProgress);
        return new BaselineCompareParameters(baselines[0], baselines[1], baselineProgress);
    }

    private void validateSelectedBaselineNames(String[] selectedBaselinesParam) throws BaselineParameterException {
        if (selectedBaselinesParam == null || selectedBaselinesParam.length <= 0 || selectedBaselinesParam.length > 2) {
            throw new InvalidBaselineNamesToCompareException();
        }
        if (selectedBaselinesParam.length == 1 ? selectedBaselinesParam[0] == null : selectedBaselinesParam[0] == null || selectedBaselinesParam[1] == null || selectedBaselinesParam[0].equals(selectedBaselinesParam[1])) {
            throw new InvalidBaselineNamesToCompareException();
        }
    }

    private PhasedBaselineProgress generateProgress(UUID operationId) {
        PhasedBaselineProgress baselineProgress = new PhasedBaselineProgress();
        if (operationId != null) {
            BaselineProgressTracker.addProgress(operationId, baselineProgress);
        }
        return baselineProgress;
    }

    private Baseline[] validateBaselines(Space space, PhasedBaselineProgress baselineProgress) throws BaselineParameterException {
        Baseline baseline2;
        boolean compareWithLatest;
        baselineProgress.addPhase(BaselineProgressPhaseType.GET_BASELINE_1_FROM_DATABASE, 5, 1);
        Baseline baseline1 = ServiceAccessor.getBaselineService().getBaseline(space, this.selectedBaselinesParam[0], BaselineDocumentTypeQuery.ANY_DOCUMENT);
        baselineProgress.tick(BaselineProgressPhaseType.GET_BASELINE_1_FROM_DATABASE);
        if (baseline1 == null) {
            throw new BaselineNotFoundException();
        }
        boolean bl = compareWithLatest = this.selectedBaselinesParam.length == 1;
        if (compareWithLatest) {
            int pageCountOfSpace = ServiceAccessor.getPageManager().getPages(space, true).size();
            baselineProgress.addPhase(BaselineProgressPhaseType.GET_SPACE_AS_BASELINE, 50, pageCountOfSpace > 0 ? pageCountOfSpace : 1);
            baseline2 = baseline1;
            baseline1 = ServiceAccessor.getBaselineService().getSpaceAsBaseline(space, baselineProgress);
            int baseline2PageCount = baseline2.getTotalPageCount();
            baselineProgress.addPhase(BaselineProgressPhaseType.FIX_BASELINE_PAGE_IDS, 35, baseline2PageCount > 0 ? baseline2PageCount : 1);
        } else {
            baselineProgress.addPhase(BaselineProgressPhaseType.GET_BASELINE_2_FROM_DATABASE, 5, 1);
            baseline2 = ServiceAccessor.getBaselineService().getBaseline(space, this.selectedBaselinesParam[1], BaselineDocumentTypeQuery.ANY_DOCUMENT);
            baselineProgress.tick(BaselineProgressPhaseType.GET_BASELINE_2_FROM_DATABASE);
            if (baseline2 == null) {
                throw new BaselineNotFoundException();
            }
            int totalBaselinePageCount = baseline1.getTotalPageCount() + baseline2.getTotalPageCount();
            baselineProgress.addPhase(BaselineProgressPhaseType.FIX_BASELINE_PAGE_IDS, 80, totalBaselinePageCount > 0 ? totalBaselinePageCount : 1);
            this.fixBaselinePageIds(baseline1, baselineProgress);
        }
        baselineProgress.addPhase(BaselineProgressPhaseType.COMPARE, 5, 1);
        baselineProgress.addPhase(BaselineProgressPhaseType.SORT, 5, 1);
        this.fixBaselinePageIds(baseline2, baselineProgress);
        return new Baseline[]{baseline1, baseline2};
    }

    private void fixBaselinePageIds(Baseline baseline, PhasedBaselineProgress baselineProgress) {
        List<BaselinePage> baselinePages = baseline.getPages();
        if (baselinePages == null || baselinePages.isEmpty()) {
            baselineProgress.tick(BaselineProgressPhaseType.FIX_BASELINE_PAGE_IDS);
            return;
        }
        for (BaselinePage baselinePage : baselinePages) {
            Page page = ServiceAccessor.getPageManager().getPage(Long.parseLong(baselinePage.getId()));
            if (page != null) {
                baselinePage.setId(page.getOriginalVersionPage() != null ? page.getOriginalVersionPage().getIdAsString() : page.getIdAsString());
            }
            baselineProgress.tick(BaselineProgressPhaseType.FIX_BASELINE_PAGE_IDS);
        }
    }

    public static class BaselineCompareParameters {
        private Baseline baseline1;
        private Baseline baseline2;
        private PhasedBaselineProgress baselineProgress;

        private BaselineCompareParameters(Baseline baseline1, Baseline baseline2, PhasedBaselineProgress baselineProgress) {
            this.baseline1 = baseline1;
            this.baseline2 = baseline2;
            this.baselineProgress = baselineProgress;
        }

        public Baseline getBaseline1() {
            return this.baseline1;
        }

        public Baseline getBaseline2() {
            return this.baseline2;
        }

        public PhasedBaselineProgress getBaselineProgress() {
            return this.baselineProgress;
        }
    }
}

