/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.servlet.core;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.VersionSpecificPermissionService;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.date.BaselineDateService;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.pager.BaselinePager;
import tr.com.obss.plugin.rest.context.HttpRequestAdapter;
import tr.com.obss.plugin.rest.context.HttpSessionAdapter;
import tr.com.obss.plugin.servlet.context.HttpServletResponseAdapter;
import tr.com.obss.plugin.utils.UrlUtils;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

public class BaseLineViewerServletCore
implements Serializable {
    private static final long serialVersionUID = 5055974830124710359L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseLineViewerServletCore.class);
    private static final String BASELINE_VIEWER_TEMPLATE = "/templates/baselineView.vm";
    private static final String NOT_AUTH_TEMPLATE = "/templates/baselineNotAuth.vm";
    private static final String LICENSE_ERROR_TEMPLATE = "/templates/baselineInvalidLicense.vm";
    private final TemplateRenderer templateRenderer;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final UserHasCondition userHasCondition;
    private final PluginLicenseManager licenseManager;
    private final BaselineDateService dateService;
    private final BaselineService baselineService;
    private final VersionSpecificPermissionService permissionService;

    public BaseLineViewerServletCore(TemplateRenderer templateRenderer, SpaceManager spaceManager, UserAccessor userAccessor, PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager licenseManager, BaselineDateService dateService, BaselineService baselineService, VersionSpecificPermissionService permissionService) {
        this.templateRenderer = templateRenderer;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.userHasCondition = new UserHasCondition(pluginSettingsFactory, userAccessor);
        this.licenseManager = licenseManager;
        this.dateService = dateService;
        this.baselineService = baselineService;
        this.permissionService = permissionService;
    }

    public void doPost(HttpRequestAdapter req, HttpServletResponseAdapter resp) {
        block15: {
            try {
                resp.setContentType("text/html;charset=utf-8");
                HashMap<String, Object> context = new HashMap<String, Object>();
                ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                if (currentUser == null) {
                    this.templateRenderer.render(NOT_AUTH_TEMPLATE, context, resp.getWriter());
                    return;
                }
                if (!Utils.isLicenseValid(this.licenseManager)) {
                    this.templateRenderer.render(LICENSE_ERROR_TEMPLATE, context, resp.getWriter());
                    return;
                }
                String spaceKey = req.getParameter("space");
                HttpSessionAdapter session = req.getSession();
                String error = (String)session.getAttribute("error");
                if (error != null) {
                    context.put("error", error);
                }
                Space space = this.spaceManager.getSpace(spaceKey);
                boolean userCanViewSpace = this.permissionService.userCanViewSpace(space);
                if (spaceKey == null || space == null || !userCanViewSpace) {
                    this.templateRenderer.render(NOT_AUTH_TEMPLATE, context, resp.getWriter());
                    return;
                }
                Boolean userIsInEditGroups = this.userHasCondition.isInEditGroups(AuthenticatedUserThreadLocal.getUsername());
                Boolean userIsInViewGroups = this.userHasCondition.isInViewGroups(AuthenticatedUserThreadLocal.getUsername());
                if (userIsInEditGroups.booleanValue() || userIsInViewGroups.booleanValue()) {
                    Set<String> permittedPageIds;
                    Baseline baseline;
                    String baselineName = req.getParameter("baseline");
                    String searchQuery = req.getParameter("searchQuery");
                    String documentTypeQuery = req.getParameter("documentTypeQuery");
                    BaselineDocumentTypeQuery documentType = BaselineDocumentTypeQuery.getByValue(documentTypeQuery);
                    if (StringUtils.isBlank((CharSequence)searchQuery)) {
                        int pageNumber;
                        context.put("showSearchResults", false);
                        try {
                            pageNumber = Integer.parseInt(req.getParameter("pageNumber"));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("pageNumber is not valid. pageNumber will be 1.", (Throwable)e);
                            pageNumber = 1;
                        }
                        baseline = this.baselineService.getBaseline(space, baselineName, pageNumber, 100, documentType);
                        permittedPageIds = this.baselineService.getPermittedPageIds(currentUser, baseline);
                        BaselinePager baselinePager = new BaselinePager(baseline, documentType);
                        context.put("baselineViewPage", baselinePager.getViewPage(pageNumber, permittedPageIds));
                    } else {
                        context.put("showSearchResults", true);
                        baseline = this.baselineService.getBaseline(space, baselineName, documentType);
                        permittedPageIds = this.baselineService.getPermittedPageIds(currentUser, baseline);
                        List<BaselineDocument> searchResults = this.baselineService.searchInBaseline(baseline, searchQuery, documentType, permittedPageIds);
                        int searchSize = searchResults.size();
                        if (searchSize > 500) {
                            context.put("moreDocuments", true);
                            searchResults.remove(searchSize - 1);
                        } else {
                            context.put("moreDocuments", false);
                        }
                        context.put("foundDocumentCount", searchResults.size());
                        context.put("searchResults", searchResults);
                        context.put("searchQuery", searchQuery.replace("\\", "\\\\"));
                    }
                    boolean canUserViewAllPages = baseline.getPageIds().size() == permittedPageIds.size();
                    context.put("canUserViewAllPages", canUserViewAllPages);
                    context.put("pageCount", baseline.getTotalPageCount());
                    context.put("attachmentCount", baseline.getTotalAttachmentCount());
                    context.put("baseline", baseline);
                    context.put("space", space);
                    context.put("baseUrl", UrlUtils.getBaseUrl(req));
                    context.put("creator", this.userAccessor.getUserByName(baseline.getCreator()));
                    context.put("df", this.dateService.getUserPreferencesDateFormatter());
                    context.put("showBaselineDate", !baseline.getBaselineDate().equals(new Date(0L)));
                    context.put("documentTypeQuery", documentTypeQuery == null ? BaselineDocumentTypeQuery.ANY_DOCUMENT.toString() : documentTypeQuery);
                    context.put("page", BaselineDocumentTypeQuery.PAGE.toString());
                    context.put("attachment", BaselineDocumentTypeQuery.ATTACHMENT.toString());
                    context.put("anyDocument", BaselineDocumentTypeQuery.ANY_DOCUMENT.toString());
                    Boolean userHasSpaceExportPermission = this.permissionService.userCanExportSpace(space);
                    context.put("hasSpaceExportPermission", userHasSpaceExportPermission);
                    Boolean userIsInExportGroups = this.userHasCondition.isInExportGroups(AuthenticatedUserThreadLocal.getUsername());
                    context.put("canExport", userIsInExportGroups);
                    context.put("isCurrentVersionEqualOrHigherThan6_13_0", Utils.isCurrentVersionEqualOrHigherThan("6.13.0"));
                    context.put("isCurrentVersionEqualOrHigherThan7_4_17", Utils.isCurrentVersionEqualOrHigherThan("7.4.17"));
                    this.templateRenderer.render(BASELINE_VIEWER_TEMPLATE, context, resp.getWriter());
                    break block15;
                }
                LOG.debug("Not authorized.");
                this.templateRenderer.render(NOT_AUTH_TEMPLATE, resp.getWriter());
            }
            catch (Exception e) {
                LOG.error("Error while listing baselines.", (Throwable)e);
                try {
                    resp.sendError(500);
                }
                catch (Exception e2) {
                    LOG.error(e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }
}

