/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest.core.impl;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.UUID;
import tr.com.obss.plugin.VersionSpecificPermissionService;
import tr.com.obss.plugin.dto.BaselineCsvSeparatorType;
import tr.com.obss.plugin.exception.BaselinePDFExportLimitException;
import tr.com.obss.plugin.export.BaselineExportService;
import tr.com.obss.plugin.export.BaselinePdfExportProcessTracker;
import tr.com.obss.plugin.rest.context.HttpRequestAdapter;
import tr.com.obss.plugin.rest.context.ResponseFactory;
import tr.com.obss.plugin.rest.core.BaselineExportRestServiceCore;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

public class BaselineExportRestServiceCoreImpl
implements BaselineExportRestServiceCore {
    private final BaselineExportService baselineExportService;
    private final UserHasCondition userHasCondition;
    private final PluginLicenseManager licenseManager;
    private final VersionSpecificPermissionService permissionService;

    public BaselineExportRestServiceCoreImpl(BaselineExportService baselineExportService, PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager licenseManager, VersionSpecificPermissionService permissionService, UserAccessor userAccessor) {
        this.baselineExportService = baselineExportService;
        this.userHasCondition = new UserHasCondition(pluginSettingsFactory, userAccessor);
        this.licenseManager = licenseManager;
        this.permissionService = permissionService;
    }

    @Override
    public Object createPdf(Long pageId, int pageVersion, String spaceKey, HttpRequestAdapter request, ResponseFactory responseFactory) {
        if (!Utils.isLicenseValid(this.licenseManager)) {
            return responseFactory.status(403).entity("Your Baselines for Confluence license has been expired.").build();
        }
        if (this.userHasCondition.isInExportGroups(AuthenticatedUserThreadLocal.get().getName()).booleanValue()) {
            String result = this.baselineExportService.createPdfForPage(pageId, pageVersion, request.getContextPath(), spaceKey);
            return responseFactory.ok(result).type("text/plain").build();
        }
        return responseFactory.status(403).entity("You are not authorized for pdf export operation.").build();
    }

    @Override
    public Object createPdfForBaseline(String baselineName, String spaceKey, HttpRequestAdapter request, ResponseFactory responseFactory) {
        if (!Utils.isLicenseValid(this.licenseManager)) {
            return responseFactory.status(403).entity("Your Baselines for Confluence license has been expired.").build();
        }
        if (this.userHasCondition.isInExportGroups(AuthenticatedUserThreadLocal.get().getName()).booleanValue() && this.permissionService.userCanExportSpace(spaceKey)) {
            try {
                UUID exportId = this.baselineExportService.createPdfForBaseline(baselineName, spaceKey, request.getContextPath());
                return responseFactory.ok(exportId != null ? exportId.toString() : null).type("text/plain").build();
            }
            catch (BaselinePDFExportLimitException e) {
                return responseFactory.badRequest(e.getMessage()).build();
            }
        }
        return responseFactory.status(403).entity("You are not authorized for pdf export operation.").build();
    }

    @Override
    public Object createCsvSemicolon(String baselineName, String spaceKey, String separatorType, HttpRequestAdapter request, ResponseFactory responseFactory) {
        if (this.userHasCondition.isInExportGroups(AuthenticatedUserThreadLocal.get().getName()).booleanValue()) {
            String requestURL = request.getRequestURL().toString();
            String requestURI = request.getRequestURI();
            String baseURL = requestURL.replace(requestURI, "") + request.getContextPath();
            BaselineCsvSeparatorType csvSeparatorType = BaselineCsvSeparatorType.lookup(separatorType);
            String result = this.baselineExportService.createCsvForBaseline(baselineName, spaceKey, csvSeparatorType, baseURL);
            return responseFactory.ok(result).type("text/plain").build();
        }
        return responseFactory.status(403).entity("You are not authorized for csv export operation.").build();
    }

    @Override
    public Object getProcess(UUID exportId, ResponseFactory responseFactory) {
        JSONObject data = new JSONObject();
        data.put("percentageComplete", BaselinePdfExportProcessTracker.getPercentageComplete(exportId));
        data.put("currentCount", BaselinePdfExportProcessTracker.getCurrentCount(exportId));
        data.put("total", BaselinePdfExportProcessTracker.getTotal(exportId));
        data.put("isCompletedSuccessfully", BaselinePdfExportProcessTracker.isCompletedSuccessfully(exportId));
        data.put("status", (Object)BaselinePdfExportProcessTracker.getStatus(exportId));
        return responseFactory.ok(data.toString()).type("application/json").build();
    }
}

