/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.UUID;
import javax.inject.Inject;
import tr.com.obss.plugin.VersionSpecificPermissionService;
import tr.com.obss.plugin.context.JakartaHttpRequestAdapter;
import tr.com.obss.plugin.context.JakartaResponseFactory;
import tr.com.obss.plugin.export.BaselineExportService;
import tr.com.obss.plugin.rest.BaselineExportRestService;
import tr.com.obss.plugin.rest.core.BaselineExportRestServiceCore;
import tr.com.obss.plugin.rest.core.impl.BaselineExportRestServiceCoreImpl;

@Path(value="/exportService")
public class JakartaBaselineExportRestService
implements BaselineExportRestService<HttpServletRequest, Response> {
    private final BaselineExportRestServiceCore core;
    private final JakartaResponseFactory responseFactory;

    @Inject
    public JakartaBaselineExportRestService(BaselineExportService baselineExportService, PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager licenseManager, VersionSpecificPermissionService permissionService, UserAccessor userAccessor) {
        this.core = new BaselineExportRestServiceCoreImpl(baselineExportService, pluginSettingsFactory, licenseManager, permissionService, userAccessor);
        this.responseFactory = new JakartaResponseFactory();
    }

    @Override
    @GET
    @Path(value="/createPdf")
    public Response createPdf(@QueryParam(value="pageId") Long pageId, @QueryParam(value="pageVersion") int pageVersion, @QueryParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) {
        return (Response)this.core.createPdf(pageId, pageVersion, spaceKey, new JakartaHttpRequestAdapter(request), this.responseFactory);
    }

    @Override
    @GET
    @Path(value="/createPdfForBaseline")
    public Response createPdfForBaseline(@QueryParam(value="baselineName") String baselineName, @QueryParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) {
        return (Response)this.core.createPdfForBaseline(baselineName, spaceKey, new JakartaHttpRequestAdapter(request), this.responseFactory);
    }

    @Override
    @GET
    @Path(value="/createCsv")
    public Response createCsvSemicolon(@QueryParam(value="baselineName") String baselineName, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="separatorType") String separatorType, @Context HttpServletRequest request) {
        return (Response)this.core.createCsvSemicolon(baselineName, spaceKey, separatorType, new JakartaHttpRequestAdapter(request), this.responseFactory);
    }

    @Override
    @GET
    @Path(value="/getProcess")
    public Response getProcess(@QueryParam(value="exportId") UUID exportId) {
        return (Response)this.core.getProcess(exportId, this.responseFactory);
    }
}

