/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.migration;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudForgeMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableForgeListener;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.info.InfoService;
import tr.com.obss.plugin.migration.MigrationDataExportService;
import tr.com.obss.plugin.migration.MigrationMappingsServiceImpl;
import tr.com.obss.plugin.migration.export.AppDataExport;
import tr.com.obss.plugin.migration.export.BaselineExport;
import tr.com.obss.plugin.migration.export.PluginSettingsExport;

public class MigrationListener
implements DiscoverableForgeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationListener.class);
    private final InfoService infoService;
    private final MigrationDataExportService migrationDataExportService;
    private final Gson objectMapper;

    public MigrationListener(InfoService infoService, MigrationDataExportService migrationDataExportService) {
        this.infoService = infoService;
        this.migrationDataExportService = migrationDataExportService;
        this.objectMapper = new GsonBuilder().create();
    }

    @Override
    public void onStartAppMigration(AppCloudForgeMigrationGateway gateway, MigrationDetailsV1 migrationDetails) {
        LOGGER.info("Migration started for Baselines with migration: {}", (Object)migrationDetails.getMigrationId());
        MigrationMappingsServiceImpl migrationMappingsService = new MigrationMappingsServiceImpl(gateway);
        try (OutputStream appDataOutputStream = gateway.createAppData(migrationDetails.getMigrationId());){
            PluginSettingsExport pluginSettingsExport = this.migrationDataExportService.preparePluginSettingsExport(migrationMappingsService);
            List<BaselineExport> baselineExports = this.migrationDataExportService.prepareBaselinesExport(migrationMappingsService);
            AppDataExport appDataExport = new AppDataExport(this.infoService.getPluginVersion(), pluginSettingsExport, baselineExports);
            appDataOutputStream.write(this.objectMapper.toJson(appDataExport).getBytes());
            gateway.completeExport();
            LOGGER.info("App data file uploaded for migration: {}", (Object)migrationDetails.getMigrationId());
        }
        catch (IOException e) {
            LOGGER.error("Migration failed for migration: {}", (Object)migrationDetails.getMigrationId());
            LOGGER.error("Exception: ", (Throwable)e);
            throw new RuntimeException("Migration failed", e);
        }
    }

    @Override
    public UUID getForgeAppId() {
        return UUID.fromString("06bde84b-ae82-4e25-8995-ccdcc9365a36");
    }

    @Override
    public String getForgeEnvironmentName() {
        return "production";
    }

    @Override
    public String getCloudAppKey() {
        return "com.obss.confluence-baseline-plugin";
    }

    @Override
    public String getServerAppKey() {
        return "com.obss.confluence-baseline-plugin";
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }
}

