/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.dto;

import java.util.Date;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentType;

public abstract class CommonBaselineDocumentPair {
    protected BaselineDocument firstDocument;
    protected BaselineDocument secondDocument;

    public CommonBaselineDocumentPair(BaselineDocument firstDocument, BaselineDocument secondDocument) {
        if (!firstDocument.getType().equals((Object)secondDocument.getType())) {
            throw new IllegalArgumentException("Document types must be equal.");
        }
        if (!firstDocument.getId().equals(secondDocument.getId())) {
            throw new IllegalArgumentException("Document ids must be equal.");
        }
        this.firstDocument = firstDocument;
        this.secondDocument = secondDocument;
    }

    public String getFirstDocumentVersion() {
        return this.firstDocument.getVersion();
    }

    public String getSecondDocumentVersion() {
        return this.secondDocument.getVersion();
    }

    public Date getFirstDocumentCreationDate() {
        return this.firstDocument.getCreationDate();
    }

    public Date getSecondDocumentCreationDate() {
        return this.secondDocument.getCreationDate();
    }

    public String getFirstDocumentUrl() {
        return this.firstDocument.getUrl();
    }

    public String getSecondDocumentUrl() {
        return this.secondDocument.getUrl();
    }

    public String getPath() {
        return this.firstDocument.getPath();
    }

    public String getTitle() {
        return this.firstDocument.getTitle();
    }

    public String getUrl() {
        return this.firstDocument.getUrl();
    }

    public BaselineDocumentType getType() {
        return this.firstDocument.getType();
    }

    public BaselineDocument getFirstDocument() {
        return this.firstDocument;
    }

    public BaselineDocument getSecondDocument() {
        return this.secondDocument;
    }

    public abstract String getCompareLink();
}

