/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.collector.page;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.collector.page.PageCollector;
import tr.com.obss.plugin.dto.CollectedAttachment;
import tr.com.obss.plugin.dto.CollectedPage;
import tr.com.obss.plugin.dto.CollectedPageMap;
import tr.com.obss.plugin.dto.SelectedPage;
import tr.com.obss.plugin.dto.SuitabilityCheckResult;
import tr.com.obss.plugin.utils.Utils;

public class DateBasedPageCollector
extends PageCollector {
    private static final Logger log = LoggerFactory.getLogger(DateBasedPageCollector.class);
    private final Date baselineDate;
    private final String baselineKeyword;
    private final Boolean selectAllPages;
    private final List<SelectedPage> partiallySelectedPages;
    private final List<SelectedPage> fullySelectedPages;
    private final CollectedPageMap collectedPages;

    public DateBasedPageCollector(Space space, Date baselineDate, String baselineKeyword, Boolean selectAllPages, List<SelectedPage> partiallySelectedPages, List<SelectedPage> fullySelectedPages) {
        super(space);
        this.baselineDate = baselineDate;
        this.baselineKeyword = baselineKeyword;
        this.selectAllPages = selectAllPages;
        this.partiallySelectedPages = partiallySelectedPages;
        this.fullySelectedPages = fullySelectedPages;
        this.collectedPages = new CollectedPageMap();
        this.detectRedundantPageCollections(partiallySelectedPages, fullySelectedPages);
    }

    @Override
    public CollectedPageMap collect() {
        if (this.selectAllPages.booleanValue()) {
            for (Page page : this.pageManager.getPages(this.space, Boolean.TRUE.booleanValue())) {
                this.collectPageIfSuitable(page);
            }
            return this.collectedPages;
        }
        this.processPartiallySelectedPages();
        this.processFullySelectedPages();
        return this.collectedPages;
    }

    private void processFullySelectedPages() {
        for (SelectedPage selectedPage : this.fullySelectedPages) {
            if (this.shouldIgnore(selectedPage.getNonPrefixId())) {
                log.info("Skipping redundantly selected fully page: {}", (Object)selectedPage.getId());
                continue;
            }
            Page fullySelectedPage = this.pageManager.getPage(Utils.convertPageId(selectedPage.getId()).longValue());
            if (Objects.isNull(fullySelectedPage)) {
                this.warnings.add(String.format("Page not found with id %s.", selectedPage.getId()));
                continue;
            }
            this.pageManager.getDescendants(fullySelectedPage).forEach(descent -> {
                if (!this.collectedPages.containsPageWithAnyVersion((Page)descent)) {
                    this.collectPageIfSuitable((Page)descent);
                }
            });
            this.collectPageIfSuitable(fullySelectedPage);
        }
    }

    private void processPartiallySelectedPages() {
        for (SelectedPage selectedPage : this.partiallySelectedPages) {
            if (this.shouldIgnore(selectedPage.getNonPrefixId())) {
                log.info("Skipping redundantly selected partially page: {}", (Object)selectedPage.getId());
                continue;
            }
            Page partiallySelectedPage = this.pageManager.getPage(Utils.convertPageId(selectedPage.getId()).longValue());
            if (Objects.isNull(partiallySelectedPage)) {
                this.warnings.add(String.format("Page not found with id %s.", selectedPage.getId()));
                continue;
            }
            this.collectPageIfSuitable(partiallySelectedPage);
        }
    }

    private void collectPageIfSuitable(Page selectedPageVersion) {
        SelectedPage selectedPage = new SelectedPage(selectedPageVersion.getIdAsString(), selectedPageVersion.getVersion());
        this.collectPageIfSuitable(selectedPage, selectedPageVersion);
    }

    private void collectPageIfSuitable(SelectedPage selectedPage, Page selectedPageVersion) {
        SuitabilityCheckResult suitabilityCheckResult = this.findLatestVersionByDateAndKeyword(selectedPageVersion);
        if (!suitabilityCheckResult.getSuitability().equals((Object)SuitabilityCheckResult.Suitability.NOT_SUITABLE)) {
            Page suitablePage = suitabilityCheckResult.getPage();
            List<CollectedAttachment> collectedAttachments = suitabilityCheckResult.getSuitability() == SuitabilityCheckResult.Suitability.DATE_SUITABLE ? this.attachmentCollector.collect(suitablePage, this.baselineDate) : this.attachmentCollector.collect(suitablePage, suitablePage.getLastModificationDate());
            CollectedPage collectedPage = new CollectedPage(selectedPage, suitablePage, collectedAttachments);
            this.collectedPages.put(suitablePage.getIdAsString(), collectedPage);
        }
        this.progressUpdateEvent();
    }

    private SuitabilityCheckResult findLatestVersionByDateAndKeyword(Page suitablePage) {
        if (Objects.isNull(suitablePage)) {
            log.warn("Page could not be found for suitability check.");
            return new SuitabilityCheckResult(SuitabilityCheckResult.Suitability.NOT_SUITABLE);
        }
        if (!suitablePage.isCurrent()) {
            this.warnings.add(String.format("Page %d was not included because it's not current.", suitablePage.getId()));
            return new SuitabilityCheckResult(SuitabilityCheckResult.Suitability.NOT_SUITABLE);
        }
        for (int pageVersion = suitablePage.getVersion(); pageVersion > 0; --pageVersion) {
            Page olderVersion = (Page)this.pageManager.getOtherVersion((ContentEntityObject)suitablePage, pageVersion);
            SuitabilityCheckResult.Suitability suitability = this.isPageSuitableForBaseline(olderVersion);
            if (suitability.equals((Object)SuitabilityCheckResult.Suitability.NOT_SUITABLE)) continue;
            return new SuitabilityCheckResult(olderVersion, suitability);
        }
        this.warnings.add(String.format("Page %d doesn't have a suitable version for date condition.", suitablePage.getId()));
        return new SuitabilityCheckResult(SuitabilityCheckResult.Suitability.NOT_SUITABLE);
    }

    private SuitabilityCheckResult.Suitability isPageSuitableForBaseline(Page page) {
        if (Objects.isNull(page)) {
            log.warn("Page could not be found for suitability check.");
            return SuitabilityCheckResult.Suitability.NOT_SUITABLE;
        }
        if (!page.isCurrent()) {
            log.warn(String.format("Page %d was not included because it's not current.", page.getId()));
            return SuitabilityCheckResult.Suitability.NOT_SUITABLE;
        }
        if (Objects.isNull(page.getLastModificationDate())) {
            log.warn("No creation or modification date for Page: id: {}, title: {}, spaceKey: {}. It is not suitable for baseline.", new Object[]{page.getLatestVersion().getIdAsString(), page.getTitle(), page.getSpaceKey()});
            return SuitabilityCheckResult.Suitability.NOT_SUITABLE;
        }
        if (page.getLastModificationDate().compareTo(this.baselineDate) > 0) {
            return SuitabilityCheckResult.Suitability.NOT_SUITABLE;
        }
        if (Objects.isNull(this.baselineKeyword) || this.baselineKeyword.isEmpty()) {
            return SuitabilityCheckResult.Suitability.DATE_SUITABLE;
        }
        if (Objects.nonNull(page.getVersionComment()) && page.getVersionComment().toLowerCase().contains(this.baselineKeyword.toLowerCase())) {
            return SuitabilityCheckResult.Suitability.KEYWORD_SUITABLE;
        }
        return SuitabilityCheckResult.Suitability.NOT_SUITABLE;
    }
}

