/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.pojo.v2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import tr.com.obss.plugin.pojo.DateTypeAdapter;
import tr.com.obss.plugin.pojo.v2.AttachmentPOJOv2;
import tr.com.obss.plugin.pojo.v2.DocumentV2;
import tr.com.obss.plugin.pojo.v2.PagePOJOv2;

public class DocumentV2Adapter
extends TypeAdapter<DocumentV2> {
    private final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter()).create();

    @Override
    public void write(JsonWriter out, DocumentV2 value) throws IOException {
        out.beginObject();
        if (value instanceof PagePOJOv2) {
            out.name("type").value("page");
        } else if (value instanceof AttachmentPOJOv2) {
            out.name("type").value("attachment");
        } else {
            throw new JsonParseException("Unknown subtype: " + value.getClass());
        }
        JsonObject obj = this.gson.toJsonTree(value).getAsJsonObject();
        for (Map.Entry<String, JsonElement> e : obj.entrySet()) {
            if ("type".equals(e.getKey())) continue;
            out.name(e.getKey());
            this.gson.toJson(e.getValue(), out);
        }
        out.endObject();
    }

    @Override
    public DocumentV2 read(JsonReader in) {
        String type;
        JsonObject jsonObject = JsonParser.parseReader(in).getAsJsonObject();
        switch (type = jsonObject.get("type").getAsString()) {
            case "page": {
                return this.gson.fromJson((JsonElement)jsonObject, PagePOJOv2.class);
            }
            case "attachment": {
                return this.gson.fromJson((JsonElement)jsonObject, AttachmentPOJOv2.class);
            }
        }
        throw new JsonParseException("Unknown type: " + type);
    }
}

