/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.export;

import com.atlassian.core.util.ProgressMeter;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.export.BaselinePdfExportProcess;

public class BaselinePdfExportProcessTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselinePdfExportProcessTracker.class);
    private static final int MAX_HOURS = 24;
    private static final int CLEAR_SIZE = 50;
    private static final int MS_TO_HOUR_DIV = 3600000;
    private static final AtomicBoolean clearing = new AtomicBoolean(false);
    private static final Map<UUID, BaselinePdfExportProcess> processMap = new ConcurrentHashMap<UUID, BaselinePdfExportProcess>();

    private BaselinePdfExportProcessTracker() {
    }

    public static void addProcess(UUID exportId, BaselinePdfExportProcess process) {
        BaselinePdfExportProcessTracker.clearOldProcesses();
        processMap.put(exportId, process);
    }

    public static boolean exists(UUID exportId) {
        if (exportId == null) {
            return false;
        }
        return processMap.containsKey(exportId);
    }

    public static int getPercentageComplete(UUID exportId) {
        ProgressMeter progressMeter = processMap.get(exportId).getProgressMeter();
        return progressMeter != null ? progressMeter.getPercentageComplete() : 0;
    }

    public static boolean isCompletedSuccessfully(UUID exportId) {
        ProgressMeter progressMeter = processMap.get(exportId).getProgressMeter();
        return progressMeter != null ? progressMeter.isCompletedSuccessfully() : Boolean.FALSE.booleanValue();
    }

    public static int getCurrentCount(UUID exportId) {
        ProgressMeter progressMeter = processMap.get(exportId).getProgressMeter();
        return progressMeter != null ? progressMeter.getCurrentCount() : 0;
    }

    public static String getStatus(UUID exportId) {
        ProgressMeter progressMeter = processMap.get(exportId).getProgressMeter();
        return progressMeter != null ? progressMeter.getStatus() : "";
    }

    public static int getTotal(UUID exportId) {
        ProgressMeter progressMeter = processMap.get(exportId).getProgressMeter();
        return progressMeter != null ? progressMeter.getTotal() : 0;
    }

    public static String getBaselineName(UUID exportId) {
        BaselinePdfExportProcess exportProcess = processMap.get(exportId);
        return exportProcess != null ? exportProcess.getBaselineName() : "";
    }

    public static String getSpaceName(UUID exportId) {
        BaselinePdfExportProcess exportProcess = processMap.get(exportId);
        return exportProcess != null ? exportProcess.getSpaceName() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearOldProcesses() {
        if (!clearing.compareAndSet(false, true)) {
            return;
        }
        if (processMap.size() < 50) {
            clearing.set(false);
            return;
        }
        try {
            Iterator<Map.Entry<UUID, BaselinePdfExportProcess>> iter = processMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<UUID, BaselinePdfExportProcess> entry = iter.next();
                long timestamp = entry.getValue().getTimestamp();
                long diff = System.currentTimeMillis() - timestamp;
                int hours = (int)(diff / 3600000L);
                if (hours < 24) continue;
                iter.remove();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while clearing processes.", (Throwable)e);
        }
        finally {
            clearing.set(false);
        }
    }
}

