/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.collector.attachment;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.ServiceAccessor;
import tr.com.obss.plugin.dto.CollectedAttachment;

public class AttachmentCollector {
    private static final Logger log = LoggerFactory.getLogger(AttachmentManager.class);

    public List<CollectedAttachment> collect(Page page) {
        return this.collect(page, null);
    }

    public List<CollectedAttachment> collect(Page page, Date date) {
        ArrayList<CollectedAttachment> collectedAttachments = new ArrayList<CollectedAttachment>();
        List<Attachment> currentAttachments = this.getOnlyCurrentAttachments(page.getLatestVersion().getAttachments());
        for (Attachment attachment : currentAttachments) {
            try {
                Attachment collectedAttachment = this.findLatestVersionOfAttachmentForBaseline(page, attachment, date);
                if (!Objects.nonNull(collectedAttachment)) continue;
                collectedAttachments.add(new CollectedAttachment(collectedAttachment));
            }
            catch (Exception e) {
                log.error("An error occurred during evaluation of attachment.", (Throwable)e);
            }
        }
        return collectedAttachments;
    }

    private List<Attachment> getOnlyCurrentAttachments(List<Attachment> attachments) {
        ArrayList<Attachment> currentAttachments = new ArrayList<Attachment>();
        for (Attachment a : attachments) {
            if (!a.isCurrent()) continue;
            currentAttachments.add(a);
        }
        return currentAttachments;
    }

    private Attachment findLatestVersionOfAttachmentForBaseline(Page baselinePage, Attachment attachment, Date date) {
        List allVersions = ServiceAccessor.getAttachmentManager().getAllVersions(attachment);
        if (Objects.isNull(date)) {
            return (Attachment)allVersions.get(0);
        }
        for (Attachment a : allVersions) {
            if (!this.isAttachmentSuitableForBaseline(baselinePage, a, date)) continue;
            return a;
        }
        return null;
    }

    private boolean isAttachmentSuitableForBaseline(Page baselinePage, Attachment attachment, Date date) {
        if (attachment == null) {
            log.warn("Attachment could not be found for suitability check.");
            return false;
        }
        if (attachment.getLastModificationDate() == null) {
            log.warn("No creation or modification date for Attachment: id: {}, title: {}, pageId: {}, pageTitle: {}, spaceKey: {}. It is not suitable for baseline.", new Object[]{attachment.getIdAsString(), attachment.getTitle(), baselinePage.getId(), baselinePage.getTitle(), attachment.getSpaceKey()});
            return false;
        }
        return attachment.getLastModificationDate().compareTo(date) <= 0;
    }
}

