/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.baseline.request;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SingleOrArrayListTypeAdapter<E>
extends TypeAdapter<List<E>> {
    private final Gson gson;
    private final TypeAdapter<E> elementAdapter;
    private final TypeAdapter<List<E>> listDelegate;

    public SingleOrArrayListTypeAdapter(Gson gson, TypeAdapter<?> elementAdapter, TypeAdapter<List<?>> listDelegate) {
        this.gson = gson;
        this.elementAdapter = elementAdapter;
        this.listDelegate = listDelegate;
    }

    @Override
    public void write(JsonWriter out, List<E> value) throws IOException {
        this.listDelegate.write(out, value);
    }

    @Override
    public List<E> read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        if (token == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (token == JsonToken.BEGIN_ARRAY) {
            return this.listDelegate.read(in);
        }
        if (token == JsonToken.BEGIN_OBJECT) {
            E element = this.elementAdapter.read(in);
            ArrayList<E> one = new ArrayList<E>(1);
            one.add(element);
            return one;
        }
        if (token == JsonToken.STRING) {
            String trimmed;
            String s2 = in.nextString();
            String string = trimmed = s2 == null ? "" : s2.trim();
            if (trimmed.isEmpty()) {
                return new ArrayList();
            }
            JsonElement parsed = JsonParser.parseString(trimmed);
            if (parsed.isJsonArray()) {
                ArrayList<E> list = new ArrayList<E>();
                for (JsonElement el : parsed.getAsJsonArray()) {
                    list.add(this.elementAdapter.fromJsonTree(el));
                }
                return list;
            }
            if (parsed.isJsonObject()) {
                ArrayList<E> one = new ArrayList<E>(1);
                one.add(this.elementAdapter.fromJsonTree(parsed));
                return one;
            }
            if (parsed.isJsonNull()) {
                return null;
            }
            throw new JsonParseException("Expected JSON array/object string for List but got: " + parsed);
        }
        throw new JsonParseException("Expected BEGIN_ARRAY/BEGIN_OBJECT/STRING/NULL for List but was: " + (Object)((Object)token));
    }
}

