/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import tr.com.obss.plugin.ExecutorResponse;
import tr.com.obss.plugin.VersionSpecificExecutor;

public class Confluence10Executor
extends ConfluenceActionSupport
implements VersionSpecificExecutor {
    private static final Logger log = LoggerFactory.getLogger(Confluence10Executor.class);

    @Override
    public ExecutorResponse executeAction() throws Exception {
        List uploadedFiles = this.strutsHelper.getUploadedFiles(this.getActiveRequest());
        if (uploadedFiles.isEmpty()) {
            this.addActionError(this.getText("pdf.font.error.nofile"));
            return new ExecutorResponse("error", null);
        }
        Object uploadedFileObj = uploadedFiles.get(0);
        try {
            Method getFileNameMethod = uploadedFileObj.getClass().getMethod("getFileName", new Class[0]);
            Method getFileMethod = uploadedFileObj.getClass().getMethod("getFile", new Class[0]);
            Method getContentTypeMethod = uploadedFileObj.getClass().getMethod("getContentType", new Class[0]);
            final String fileName = (String)getFileNameMethod.invoke(uploadedFileObj, new Object[0]);
            File file = (File)getFileMethod.invoke(uploadedFileObj, new Object[0]);
            String contentType = (String)getContentTypeMethod.invoke(uploadedFileObj, new Object[0]);
            String extension = FilenameUtils.getExtension((String)fileName);
            if (!extension.equals("ttf") && !extension.equals("ttc")) {
                this.addActionError(this.getText("pdf.error.file.extension"));
                return new ExecutorResponse("error", null);
            }
            if (!contentType.equals("font/ttf") && !contentType.equals("application/octet-stream")) {
                this.addActionError(this.getText("pdf.font.error.contenttype"));
                return new ExecutorResponse("error", null);
            }
            return new ExecutorResponse("success", (Resource)new FileSystemResource(file){

                public String getFilename() {
                    return fileName;
                }
            });
        }
        catch (Exception ex) {
            log.error("Unable to install language font.", (Throwable)ex);
            this.addActionError(ex.getMessage());
            return new ExecutorResponse("error", null);
        }
    }
}

