/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.utils;

import com.atlassian.confluence.setup.BootstrapManager;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.utils.FileUtils;

public class ConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtils.class);
    private static final String PROPERTIES_FILENAME = "baselines.properties";
    private BootstrapManager bootstrapManager;
    private Properties cachedProperties;

    public ConfigUtils(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    private Optional<String> getPropertiesFilePath() {
        String propertiesFile = Paths.get(this.bootstrapManager.getLocalHome().getPath(), PROPERTIES_FILENAME).toString();
        if (FileUtils.fileExists(propertiesFile)) {
            logger.debug("File found in: {}", (Object)propertiesFile);
            return Optional.of(propertiesFile);
        }
        propertiesFile = Paths.get(this.bootstrapManager.getSharedHome().getPath(), PROPERTIES_FILENAME).toString();
        if (FileUtils.fileExists(propertiesFile)) {
            logger.debug("File found in: {}", (Object)propertiesFile);
            return Optional.of(propertiesFile);
        }
        return Optional.empty();
    }

    private Properties getProperties() throws IOException {
        if (this.cachedProperties == null) {
            Properties properties = new Properties();
            Optional<String> propertiesFilePath = this.getPropertiesFilePath();
            if (propertiesFilePath.isPresent()) {
                properties.load(FileUtils.getFileInputStream(propertiesFilePath.get()));
            }
            this.cachedProperties = properties;
        }
        return this.cachedProperties;
    }

    public Optional<String> readPropertyValue(String propertyName) {
        try {
            Properties properties = this.getProperties();
            return Optional.ofNullable(properties.getProperty(propertyName));
        }
        catch (IOException e) {
            logger.warn("Unexpected exception while opening properties file", (Throwable)e);
            return Optional.empty();
        }
    }

    public String readStringPropertyValue(String propertyName, String defaultValue) {
        return this.readPropertyValue(propertyName).orElse(defaultValue);
    }

    public int readIntPropertyValue(String propertyName, int defaultValue) {
        return this.readPropertyValue(propertyName).map(v -> {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException exception) {
                logger.warn("Provided property for property {} must be an integer value: {}", (Object)propertyName, v);
                return defaultValue;
            }
        }).orElse(defaultValue);
    }

    public boolean readBooleanPropertyValue(String propertyName, boolean defaultValue) {
        return this.readPropertyValue(propertyName).map(v -> !"false".equalsIgnoreCase((String)v)).orElse(defaultValue);
    }
}

