/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest.core.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.PageInBaselineComparator;
import tr.com.obss.plugin.VersionSpecificPermissionManager;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.date.BaselineDateService;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.dto.BaselinePage;
import tr.com.obss.plugin.extra.flyingpdf.manager.PermissionManagerFactory;
import tr.com.obss.plugin.rest.PageInBaseline;
import tr.com.obss.plugin.rest.context.HttpRequestAdapter;
import tr.com.obss.plugin.rest.context.ResponseFactory;
import tr.com.obss.plugin.rest.core.PagesServiceCore;
import tr.com.obss.plugin.utils.UrlUtils;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

public class PagesServiceCoreImpl
implements PagesServiceCore {
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final TemplateRenderer templateRenderer;
    private final UserHasCondition userHasCondition;
    private final BaselineDateService dateService;
    private final BaselineService baselineService;
    private final VersionSpecificPermissionManager permissionManager;
    private static final Logger logger = LoggerFactory.getLogger(PagesServiceCoreImpl.class);

    public PagesServiceCoreImpl(SpaceManager spaceManager, PageManager pageManager, TemplateRenderer templateRenderer, PluginSettingsFactory pluginSettingsFactory, BaselineDateService dateService, BaselineService baselineService, PermissionManager permissionManager, UserAccessor userAccessor) {
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.templateRenderer = templateRenderer;
        this.dateService = dateService;
        this.baselineService = baselineService;
        this.permissionManager = PermissionManagerFactory.getPermissionManager(permissionManager);
        this.userHasCondition = new UserHasCondition(pluginSettingsFactory, userAccessor);
    }

    @Override
    public Object getSubpagesOfPage(HttpRequestAdapter req, ResponseFactory responseFactory) {
        long pageId;
        String pageIdParam = req.getParameter("pageId");
        try {
            pageId = Utils.convertPageId(pageIdParam);
        }
        catch (NumberFormatException e) {
            logger.error("Error while parsing pageId. pageId: " + pageIdParam, (Throwable)e);
            return responseFactory.badRequest("Invalid pageId.").build();
        }
        Page page = this.pageManager.getPage(pageId);
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (page == null || !this.permissionManager.hasPermission((Object)currentUser, Permission.VIEW, (AbstractPage)page)) {
            return responseFactory.badRequest("You do not have permission to view this page or it does not exist.").build();
        }
        List immediateChildren = page.getChildren();
        List<Page> permittedPages = this.permissionManager.getPermittedEntities(currentUser, Permission.VIEW, immediateChildren);
        return responseFactory.ok(this.createJsonStringFromPageList(permittedPages)).type("text/plain").build();
    }

    @Override
    public Object getBelongingBaselines(HttpRequestAdapter req, ResponseFactory responseFactory) {
        StringWriter htmlResultWriter = new StringWriter();
        HashMap<String, Object> context = new HashMap<String, Object>();
        try {
            String pageId = Utils.removePagePrefix(req.getParameter("pageId"));
            Page currentPage = this.pageManager.getPage(Utils.convertPageId(pageId).longValue());
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            boolean canUserViewPage = this.permissionManager.hasPermission((Object)currentUser, Permission.VIEW, (AbstractPage)currentPage);
            Boolean userIsInViewGroups = this.userHasCondition.isInViewGroups(AuthenticatedUserThreadLocal.getUsername());
            Boolean userIsInEditGroups = this.userHasCondition.isInEditGroups(AuthenticatedUserThreadLocal.getUsername());
            if (!canUserViewPage || !userIsInViewGroups.booleanValue() && !userIsInEditGroups.booleanValue()) {
                this.templateRenderer.render("/templates/component/showBaselinesDialogNoAuth.vm", context, (Writer)htmlResultWriter);
            } else {
                String spaceKey = req.getParameter("currentSpaceKey");
                Space space = this.spaceManager.getSpace(spaceKey);
                Boolean userIsInExportGroups = this.userHasCondition.isInExportGroups(AuthenticatedUserThreadLocal.getUsername());
                context.put("latestPageVersion", currentPage.getVersion());
                context.put("spaceKey", spaceKey);
                context.put("baselineSet", this.generateBaselineMap(space, pageId));
                context.put("dateFormatter", this.dateService.getUserPreferencesDateFormatter());
                context.put("baseUrl", UrlUtils.getBaseUrl(req));
                context.put("canExport", userIsInExportGroups);
                context.put("zeroDate", new Date(0L));
                this.templateRenderer.render("/templates/component/showBaselinesDialog.vm", context, (Writer)htmlResultWriter);
            }
        }
        catch (Exception e) {
            logger.error("Error while rendering show baselines dialog.", (Throwable)e);
        }
        return responseFactory.ok(htmlResultWriter.toString()).type("text/plain").build();
    }

    @Override
    public Object getTopLevelPagesForSpace(HttpRequestAdapter req, ResponseFactory responseFactory) {
        long spaceId;
        String spaceIdParam = req.getParameter("spaceId");
        try {
            spaceId = Long.parseLong(spaceIdParam);
        }
        catch (NumberFormatException e) {
            logger.error("Error while parsing spaceId. spaceId: " + spaceIdParam, (Throwable)e);
            return responseFactory.badRequest("Invalid spaceId.").build();
        }
        Space space = this.spaceManager.getSpace(spaceId);
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (space == null || !this.permissionManager.hasPermission((Object)currentUser, Permission.VIEW, space)) {
            return responseFactory.badRequest("You do not have permission to view this space or it does not exist.").build();
        }
        List topLevelPages = this.pageManager.getTopLevelPages(space);
        List<Page> permittedPages = this.permissionManager.getPermittedEntities(currentUser, Permission.VIEW, topLevelPages);
        return responseFactory.ok(this.createJsonStringFromPageList(permittedPages)).type("text/plain").build();
    }

    @Override
    public Object renderTreeComponent(HttpRequestAdapter req, ResponseFactory responseFactory) {
        StringWriter htmlResultWriter = new StringWriter();
        HashMap<String, Space> context = new HashMap<String, Space>();
        String spaceKey = req.getParameter("spaceKey");
        Space space = this.spaceManager.getSpace(spaceKey);
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (space == null || !this.permissionManager.hasPermission((Object)currentUser, Permission.VIEW, space)) {
            return responseFactory.badRequest("You do not have permission to view this space or it does not exist.").build();
        }
        context.put("space", space);
        try {
            this.templateRenderer.render("/templates/component/treeViewComponent.vm", context, (Writer)htmlResultWriter);
        }
        catch (RenderingException | IOException e) {
            logger.error("Error while rendering space tree.", e);
        }
        return responseFactory.ok(htmlResultWriter.toString()).type("text/plain").build();
    }

    private SortedSet<PageInBaseline> generateBaselineMap(Space space, String pageId) {
        logger.debug("Getting baselines for page: spaceKey: {} {}, pageId: {}", new Object[]{space.getKey(), space.getName(), pageId});
        TreeSet<PageInBaseline> baselineSet = new TreeSet<PageInBaseline>(new PageInBaselineComparator());
        List<String> baselineNames = this.baselineService.getBaselineNames(space);
        for (String baselineName : baselineNames) {
            Baseline baseline = this.baselineService.getBaseline(space, baselineName, BaselineDocumentTypeQuery.PAGE);
            if (baseline == null) {
                logger.warn("baseline {} could not be found/parsed in space {}. Skipping this baseline.", (Object)baselineName, (Object)space.getKey());
                continue;
            }
            BaselinePage page = baseline.getPageById(pageId);
            if (page != null) {
                logger.debug("baseline {} contains page {}. Including baseline.", (Object)baselineName, (Object)pageId);
                PageInBaseline pageInBaseline = new PageInBaseline(baseline, page);
                baselineSet.add(pageInBaseline);
                continue;
            }
            logger.debug("baseline {} does not contain page {}. Excluding baseline.", (Object)baselineName, (Object)pageId);
        }
        return baselineSet;
    }

    private String createJsonStringFromPageList(List<Page> immediateChildren) {
        JsonArray pagesJsonArray = new JsonArray();
        for (Page page : immediateChildren) {
            JsonObject pageJsonObject = new JsonObject();
            pageJsonObject.addProperty("id", "bsl_" + page.getIdAsString());
            pageJsonObject.addProperty("title", page.getDisplayTitle());
            pageJsonObject.addProperty("hasChildren", page.hasChildren());
            JsonArray versionsJsonArray = new JsonArray();
            this.pageManager.getVersionHistorySummaries((ContentEntityObject)page).stream().map(VersionHistorySummary::getVersion).sorted(Collections.reverseOrder()).map(JsonPrimitive::new).forEach(versionsJsonArray::add);
            pageJsonObject.add("versions", versionsJsonArray);
            pagesJsonArray.add(pageJsonObject);
        }
        return pagesJsonArray.toString();
    }
}

