/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.rpc;

import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import tr.com.obss.plugin.VersionSpecificPermissionManager;
import tr.com.obss.plugin.extra.flyingpdf.DelegatingPdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.analytic.SpaceExportMetrics;
import tr.com.obss.plugin.extra.flyingpdf.manager.PermissionManagerFactory;

public class PdfExportRpcDelegatorImpl {
    private SpaceManager spaceManager;
    private VersionSpecificPermissionManager permissionManager;
    private ImportExportManager importExportManager;
    private DelegatingPdfExporterService pdfExporterService;
    private GateKeeper gateKeeper;
    private SettingsManager settingsManager;
    private TransactionTemplate transactionTemplate;

    public String exportSpace(final String spaceKey) throws RemoteException {
        Object obj = this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                String downloadPath;
                Space space = PdfExportRpcDelegatorImpl.this.spaceManager.getSpace(spaceKey);
                if (space == null) {
                    return new RemoteException("Invalid spaceKey: [" + spaceKey + "]");
                }
                ConfluenceUser user = AuthenticatedUserThreadLocal.get();
                if (!PdfExportRpcDelegatorImpl.this.hasPermission((User)user, Permission.EXPORT, space)) {
                    return new NotPermittedException("You don't have permission to export the space: " + space.getKey());
                }
                ContentTree contentTree = PdfExportRpcDelegatorImpl.this.importExportManager.getContentTree((User)user, space);
                try {
                    String contextPath = ServletContextThreadLocal.getRequest().getContextPath();
                    File pdfFile = PdfExportRpcDelegatorImpl.this.pdfExporterService.createPdfForSpace((User)user, space, contentTree, contextPath, new SpaceExportMetrics());
                    downloadPath = PdfExportRpcDelegatorImpl.this.importExportManager.prepareDownloadPath(pdfFile.getAbsolutePath());
                    Predicate<User> permissionPredicate = u -> PdfExportRpcDelegatorImpl.this.permissionManager.hasPermission(u, Permission.EXPORT, space);
                    PdfExportRpcDelegatorImpl.this.gateKeeper.addKey(downloadPath, (User)user, permissionPredicate);
                }
                catch (ImportExportException e) {
                    return new RemoteException(e.getMessage());
                }
                catch (IOException e) {
                    return new RemoteException(e.getMessage());
                }
                return downloadPath;
            }
        });
        if (obj instanceof RemoteException) {
            throw (RemoteException)obj;
        }
        String downloadPath = (String)obj;
        return this.settingsManager.getGlobalSettings().getBaseUrl() + downloadPath;
    }

    private boolean hasPermission(User user, Permission permission, Space space) {
        return this.permissionManager.hasPermission((Object)user, permission, space);
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setFlyingPdfExporterService(DelegatingPdfExporterService pdfExporterService) {
        this.pdfExporterService = pdfExporterService;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = PermissionManagerFactory.getPermissionManager(permissionManager);
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

