/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.executor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.Confluence10Executor;
import tr.com.obss.plugin.Confluence7And8And9Executor;
import tr.com.obss.plugin.VersionSpecificExecutor;

public class VersionSpecificExecutorFactory {
    private static final Logger logger = LoggerFactory.getLogger(VersionSpecificExecutorFactory.class);

    public static VersionSpecificExecutor getExecutor(String confluenceVersion) {
        logger.debug("Detected Confluence version: {}", (Object)confluenceVersion);
        if (confluenceVersion == null) {
            logger.error("Cannot determine Confluence version. Confluence Version is null");
            return null;
        }
        if (confluenceVersion.startsWith("10")) {
            logger.debug("Using Confluence10Executor()");
            return new Confluence10Executor();
        }
        if (confluenceVersion.startsWith("7") || confluenceVersion.startsWith("8") || confluenceVersion.startsWith("9")) {
            logger.debug("Using Confluence7And8And9Executor()");
            return new Confluence7And8And9Executor();
        }
        return null;
    }
}

