/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.xhtmlrenderer.util.Configuration;

public class XRSimpleLogFormatter
extends Formatter {
    private final MessageFormat mformat = new MessageFormat(msgFmt);
    private final MessageFormat exmformat = new MessageFormat(exmsgFmt);
    private static final String msgFmt = Configuration.valueFor("xr.simple-log-format", "{1}:\n  {5}\n").trim() + "\n";
    private static final String exmsgFmt = Configuration.valueFor("xr.simple-log-format-throwable", "{1}:\n  {5}\n{8}").trim() + "\n";

    @Override
    public String format(LogRecord record) {
        Throwable th = record.getThrown();
        String thName = "";
        String thMessage = "";
        String trace = null;
        if (th != null) {
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter(sw));
            trace = sw.toString();
            thName = th.getClass().getName();
            thMessage = th.getMessage();
        }
        String[] args = new String[]{String.valueOf(record.getMillis()), record.getLoggerName(), record.getLevel().toString(), record.getSourceClassName(), record.getSourceMethodName(), record.getMessage(), thName, thMessage, trace};
        String log = null;
        log = th == null ? this.mformat.format(args) : this.exmformat.format(args);
        return log;
    }

    @Override
    public String formatMessage(LogRecord record) {
        return super.formatMessage(record);
    }

    @Override
    public String getHead(Handler h2) {
        return super.getHead(h2);
    }

    @Override
    public String getTail(Handler h2) {
        return super.getTail(h2);
    }
}

