/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.utils;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.dto.SelectedPage;
import tr.com.obss.plugin.rest.context.HttpRequestAdapter;
import tr.com.obss.plugin.servlet.context.HttpServletResponseAdapter;
import tr.com.obss.plugin.utils.ConfluenceVersionComparator;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final Gson gson = new GsonBuilder().create();
    private static Comparator<String> confluenceVersionComparator = new ConfluenceVersionComparator();

    private Utils() {
    }

    public static String removePagePrefix(String text) {
        if (Objects.isNull(text)) {
            return null;
        }
        return text.replace("bsl_", "");
    }

    public static Long convertPageId(String text) {
        String nonPrefix = Utils.removePagePrefix(text);
        return Long.parseLong(nonPrefix);
    }

    public static boolean isLicenseValid(PluginLicenseManager licenseManager) {
        try {
            if (licenseManager.getLicense().isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)licenseManager.getLicense().get();
                return !pluginLicense.getError().isDefined();
            }
            return false;
        }
        catch (Exception e) {
            log.error("License Manager couldn't get license.", (Throwable)e);
            return false;
        }
    }

    public static void redirectToLogin(HttpRequestAdapter req, HttpServletResponseAdapter resp, LoginUriProvider loginUriProvider) {
        resp.sendRedirect(loginUriProvider.getLoginUri(URI.create(req.getRequestURL().toString())).toASCIIString());
    }

    public static List<String> getAllGroupNames() {
        ArrayList<String> allGroupNames = new ArrayList<String>();
        List allGroups = ((UserAccessor)ComponentLocator.getComponent(UserAccessor.class)).getGroupsAsList();
        for (Group group : allGroups) {
            allGroupNames.add(group.getName());
        }
        return allGroupNames;
    }

    public static List<String> getGroupNamesForUser(User user) {
        Pager userGroups;
        ArrayList<String> groupNames = new ArrayList<String>();
        try {
            userGroups = ((GroupManager)ComponentLocator.getComponent(GroupManager.class)).getGroups(user);
        }
        catch (EntityException e) {
            throw new RuntimeException(e);
        }
        while (userGroups.iterator().hasNext()) {
            Group group = (Group)userGroups.iterator().next();
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    public static String generatePagePath(Page page) {
        Page originalVersion;
        StringBuilder sb = new StringBuilder();
        Page parentPage = page.getParent();
        if (parentPage == null && (originalVersion = (Page)page.getOriginalVersionPage()) != null) {
            parentPage = originalVersion.getParent();
        }
        while (parentPage != null) {
            sb.insert(0, parentPage.getTitle() + " \\ ");
            parentPage = parentPage.getParent();
        }
        return sb.toString();
    }

    public static String generatePageUrl(Page page) {
        return "/pages/viewpage.action?pageId=" + page.getLatestVersion().getIdAsString() + "&pageVersion=" + page.getVersion();
    }

    public static boolean isValidSelectedPageJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return false;
        }
        try {
            gson.fromJson(json.trim(), SelectedPage[].class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isSelectedPageValid(String page) {
        if (Objects.isNull(page)) {
            return false;
        }
        page = page.replace("bsl_", "");
        return page.trim().matches("([0-9]*)");
    }

    public static boolean isValidSelectAllPagesBoolean(String selectAllPagesParameter) {
        return "false".equalsIgnoreCase(selectAllPagesParameter) || "true".equalsIgnoreCase(selectAllPagesParameter);
    }

    public static boolean isCurrentVersionEqualOrHigherThan(String targetVersion) {
        return confluenceVersionComparator.compare(GeneralUtil.getVersionNumber(), targetVersion) >= 0;
    }
}

