/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.baseline.parameter;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import tr.com.obss.plugin.ServiceAccessor;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameters;
import tr.com.obss.plugin.baseline.parameter.BaselineParameterBuilder;
import tr.com.obss.plugin.baseline.request.BaselineCreateRequest;
import tr.com.obss.plugin.dto.BaselineCreationType;
import tr.com.obss.plugin.dto.SelectedPage;
import tr.com.obss.plugin.exception.BaselineDateCannotBeUsedException;
import tr.com.obss.plugin.exception.BaselineDateParameterIsRequiredException;
import tr.com.obss.plugin.exception.BaselineNameAlreadyExistsException;
import tr.com.obss.plugin.exception.BaselineNameParameterIsRequiredException;
import tr.com.obss.plugin.exception.BaselineNameTooLongException;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.exception.FullySelectedPagesParameterCannotBeUsedException;
import tr.com.obss.plugin.exception.InvalidBaselineCreationTypeParameterException;
import tr.com.obss.plugin.exception.InvalidBaselineDateException;
import tr.com.obss.plugin.exception.InvalidFullySelectedPagesParameterException;
import tr.com.obss.plugin.exception.InvalidPartiallySelectedPagesParameterException;
import tr.com.obss.plugin.exception.NoPageSelectedException;
import tr.com.obss.plugin.exception.PartiallySelectedPagesParameterCannotBeUsedException;
import tr.com.obss.plugin.exception.SelectAllPagesParamCannotBeUsedException;
import tr.com.obss.plugin.exception.SelectAllPagesParameterNotBooleanException;
import tr.com.obss.plugin.utils.Utils;

public class BaselineCreateParameterBuilder
extends BaselineParameterBuilder {
    private final BaselineCreateRequest createRequest;
    private final BaselineCreateParameters parameters;

    public BaselineCreateParameterBuilder(BaselineCreateRequest createRequest) {
        super(createRequest.getOperationId(), createRequest.getSpaceKey());
        this.createRequest = createRequest;
        this.parameters = new BaselineCreateParameters();
    }

    public BaselineCreateParameters build() throws BaselineParameterException {
        this.parameters.setOperationId(this.validateOperationId());
        this.parameters.setSpace(this.validateSpace());
        this.buildBaselineName();
        this.buildCreationType();
        this.buildBaselineDate();
        this.buildSelectAllPages();
        this.buildSelectedPages();
        this.buildBaselineKeywords();
        return this.parameters;
    }

    private void buildBaselineKeywords() {
        this.parameters.setBaselineKeyword(Objects.isNull(this.createRequest.getBaselineKeyword()) ? "" : this.createRequest.getBaselineKeyword().trim());
    }

    private void buildSelectedPages() throws BaselineParameterException {
        List<SelectedPage> partiallySelectedPagesParam = this.createRequest.getPartiallySelectedPages();
        List<SelectedPage> fullySelectedPagesParam = this.createRequest.getFullySelectedPages();
        if (this.parameters.getSelectAllPages().booleanValue()) {
            if (!BaselineCreationType.DATE_BASED.equals((Object)this.parameters.getCreationType())) {
                throw new SelectAllPagesParamCannotBeUsedException();
            }
            if (!CollectionUtils.isEmpty(partiallySelectedPagesParam)) {
                throw new PartiallySelectedPagesParameterCannotBeUsedException();
            }
            if (!CollectionUtils.isEmpty(fullySelectedPagesParam)) {
                throw new FullySelectedPagesParameterCannotBeUsedException();
            }
        } else {
            if (CollectionUtils.isEmpty(partiallySelectedPagesParam) && CollectionUtils.isEmpty(fullySelectedPagesParam)) {
                throw new NoPageSelectedException();
            }
            if (!CollectionUtils.isEmpty(partiallySelectedPagesParam)) {
                SelectedPage.SelectedPages partiallySelectedPages = new SelectedPage.SelectedPages();
                for (SelectedPage partiallySelectedPage : partiallySelectedPagesParam) {
                    if (Utils.isSelectedPageValid(partiallySelectedPage.getId())) continue;
                    throw new InvalidPartiallySelectedPagesParameterException();
                }
                partiallySelectedPages.addAll(partiallySelectedPagesParam);
                this.parameters.setPartiallySelectedPages(partiallySelectedPages);
            }
            if (!CollectionUtils.isEmpty(fullySelectedPagesParam)) {
                SelectedPage.SelectedPages fullySelectedPages = new SelectedPage.SelectedPages();
                for (SelectedPage fullySelectedPage : fullySelectedPagesParam) {
                    if (Utils.isSelectedPageValid(fullySelectedPage.getId())) continue;
                    throw new InvalidFullySelectedPagesParameterException();
                }
                fullySelectedPages.addAll(fullySelectedPagesParam);
                this.parameters.setFullySelectedPages(fullySelectedPages);
            }
        }
    }

    private void buildSelectAllPages() throws BaselineParameterException {
        String selectAllPagesParam = Optional.ofNullable(this.createRequest.getSelectAllPages()).orElse(Boolean.FALSE.toString()).trim();
        if (!Utils.isValidSelectAllPagesBoolean(selectAllPagesParam)) {
            throw new SelectAllPagesParameterNotBooleanException();
        }
        boolean selectAllPages = Boolean.parseBoolean(selectAllPagesParam);
        this.parameters.setSelectAllPages(selectAllPages);
    }

    private void buildBaselineDate() throws BaselineParameterException {
        String baselineDateParam = this.createRequest.getBaselineDate();
        if (StringUtils.isBlank((CharSequence)baselineDateParam)) {
            baselineDateParam = this.createRequest.getDateField();
        }
        if (BaselineCreationType.DATE_BASED.equals((Object)this.parameters.getCreationType())) {
            if (StringUtils.isBlank((CharSequence)baselineDateParam)) {
                throw new BaselineDateParameterIsRequiredException();
            }
            Date baselineDate = ServiceAccessor.getDateService().convertToServerDate(baselineDateParam.trim());
            if (Objects.isNull(baselineDate)) {
                throw new InvalidBaselineDateException();
            }
            this.parameters.setBaselineDate(baselineDate);
        } else if (baselineDateParam != null && !baselineDateParam.equals("")) {
            throw new BaselineDateCannotBeUsedException();
        }
    }

    private void buildCreationType() throws BaselineParameterException {
        String creationTypeParam = this.createRequest.getCreationType();
        if (StringUtils.isBlank((CharSequence)creationTypeParam)) {
            throw new InvalidBaselineCreationTypeParameterException();
        }
        try {
            BaselineCreationType creationType = BaselineCreationType.getValue(creationTypeParam);
            this.parameters.setCreationType(creationType);
        }
        catch (Exception e) {
            throw new InvalidBaselineCreationTypeParameterException();
        }
    }

    private void buildBaselineName() throws BaselineParameterException {
        String baselineNameParam = this.createRequest.getBaselineName();
        if (StringUtils.isBlank((CharSequence)baselineNameParam)) {
            throw new BaselineNameParameterIsRequiredException();
        }
        String trimmedBaselineName = baselineNameParam.trim();
        BaselineService baselineService = ServiceAccessor.getBaselineService();
        if (baselineService.isBaselineNameTooLong(trimmedBaselineName)) {
            throw new BaselineNameTooLongException();
        }
        if (baselineService.doesBaselineNameExist(this.parameters.getSpace(), trimmedBaselineName)) {
            throw new BaselineNameAlreadyExistsException();
        }
        this.parameters.setBaselineName(trimmedBaselineName);
    }
}

