/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.servlet.core;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.export.BaselinePdfExportProcessTracker;
import tr.com.obss.plugin.rest.context.HttpRequestAdapter;
import tr.com.obss.plugin.servlet.context.HttpServletResponseAdapter;
import tr.com.obss.plugin.utils.UrlUtils;

public class BaseLineExportProgressServletCore
implements Serializable {
    private static final long serialVersionUID = -5545255337053993993L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseLineExportProgressServletCore.class);
    private static final String EXPORT_PROGRESS_TEMPLATE = "/templates/baselineExportProgress.vm";
    private final TemplateRenderer templateRenderer;
    private final LoginUriProvider loginUriProvider;

    public BaseLineExportProgressServletCore(TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
    }

    public void doGet(HttpRequestAdapter req, HttpServletResponseAdapter resp) throws IOException {
        try {
            if (AuthenticatedUserThreadLocal.get() == null) {
                this.redirectToLogin(req, resp);
                return;
            }
            resp.setContentType("text/html;charset=utf-8");
            HashMap<String, Object> context = new HashMap<String, Object>();
            String exportIdAsString = req.getParameter("exportId");
            this.fillContext(context, exportIdAsString, req);
            this.templateRenderer.render(EXPORT_PROGRESS_TEMPLATE, context, resp.getWriter());
        }
        catch (Exception e) {
            LOG.error("Error while rendering baseline export progress page.", (Throwable)e);
        }
    }

    private void fillContext(Map<String, Object> context, String exportIdAsString, HttpRequestAdapter request) {
        try {
            UUID exportId = UUID.fromString(exportIdAsString);
            context.put("processExists", BaselinePdfExportProcessTracker.exists(exportId));
            context.put("exportId", exportIdAsString);
            context.put("baseUrl", UrlUtils.getBaseUrl(request));
            context.put("baselineName", BaselinePdfExportProcessTracker.getBaselineName(exportId));
            context.put("spaceName", BaselinePdfExportProcessTracker.getSpaceName(exportId));
        }
        catch (Exception e) {
            LOG.warn("Error while getting export process info.", (Throwable)e);
            context.put("processExists", false);
        }
    }

    private void redirectToLogin(HttpRequestAdapter req, HttpServletResponseAdapter resp) throws IOException {
        resp.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(req.getRequestURL().toString())).toASCIIString());
    }
}

