/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.pojo;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Date;

public class DateTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    @Override
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(src.getTime());
    }

    @Override
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = json.getAsJsonPrimitive();
            if (prim.isNumber()) {
                return new Date(prim.getAsLong());
            }
            if (prim.isString()) {
                String dateString = prim.getAsString();
                try {
                    long epochMillis = Long.parseLong(dateString);
                    return new Date(epochMillis);
                }
                catch (NumberFormatException e) {
                    return Date.from(Instant.parse(dateString));
                }
            }
        }
        throw new JsonParseException("Unsupported date format: " + json);
    }
}

