/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.collector.factory;

import org.springframework.stereotype.Component;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameters;
import tr.com.obss.plugin.collector.page.DateBasedPageCollector;
import tr.com.obss.plugin.collector.page.PageCollector;
import tr.com.obss.plugin.collector.page.VersionBasedPageCollector;
import tr.com.obss.plugin.exception.InvalidBaselineCreationTypeParameterException;

@Component
public class PageCollectorFactory {
    public static PageCollector getPageCollector(BaselineCreateParameters parameters) throws InvalidBaselineCreationTypeParameterException {
        switch (parameters.getCreationType()) {
            case VERSION_BASED: {
                return new VersionBasedPageCollector(parameters.getSpace(), parameters.getPartiallySelectedPages(), parameters.getFullySelectedPages());
            }
            case DATE_BASED: {
                return new DateBasedPageCollector(parameters.getSpace(), parameters.getBaselineDate(), parameters.getBaselineKeyword(), parameters.getSelectAllPages(), parameters.getPartiallySelectedPages(), parameters.getFullySelectedPages());
            }
        }
        throw new InvalidBaselineCreationTypeParameterException();
    }
}

